/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;

public class RandomDegreeSelectionStrategy
implements SelectionStrategy {
    private final long samplingSize;
    private final Optional<Long> maybeRandomSeed;
    private final AtomicLong nodeQueue = new AtomicLong();
    private long graphSize;
    private BitSet sampleSet;

    public RandomDegreeSelectionStrategy(long samplingSize) {
        this(samplingSize, Optional.empty());
    }

    public RandomDegreeSelectionStrategy(long samplingSize, Optional<Long> maybeRandomSeed) {
        this.samplingSize = samplingSize;
        this.maybeRandomSeed = maybeRandomSeed;
    }

    @Override
    public void init(Graph graph, ExecutorService executorService, int concurrency) {
        assert (this.samplingSize <= graph.nodeCount());
        this.sampleSet = new BitSet(graph.nodeCount());
        this.graphSize = graph.nodeCount();
        this.nodeQueue.set(0L);
        List partitions = PartitionUtils.numberAlignedPartitioning((int)concurrency, (long)graph.nodeCount(), (long)64L);
        int maxDegree = RandomDegreeSelectionStrategy.maxDegree(graph, partitions, executorService, concurrency);
        this.selectNodes(graph, partitions, maxDegree, executorService, concurrency);
    }

    @Override
    public long next() {
        long nextNodeId;
        while ((nextNodeId = this.nodeQueue.getAndIncrement()) < this.graphSize) {
            if (!this.sampleSet.get(nextNodeId)) continue;
            return nextNodeId;
        }
        return -1L;
    }

    private static int maxDegree(Graph graph, Collection<Partition> partitions, ExecutorService executorService, int concurrency) {
        AtomicInteger maxDegree = new AtomicInteger(0);
        List tasks = partitions.stream().map(partition -> () -> partition.consume(nodeId -> {
            int newCurrent;
            int degree = graph.degree(nodeId);
            int current = maxDegree.get();
            while (degree > current && (newCurrent = maxDegree.compareAndExchange(current, degree)) != current) {
                current = newCurrent;
            }
        })).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(concurrency).tasks(tasks).executor(executorService).run();
        return maxDegree.get();
    }

    private void selectNodes(Graph graph, Collection<Partition> partitions, int maxDegree, ExecutorService executorService, int concurrency) {
        SplittableRandom random = this.maybeRandomSeed.map(SplittableRandom::new).orElseGet(SplittableRandom::new);
        AtomicLong selectionSize = new AtomicLong(0L);
        List tasks = partitions.stream().map(partition -> () -> {
            long currentSelectionSize;
            SplittableRandom threadLocalRandom = random.split();
            long fromNode = partition.startNode();
            long toNode = partition.startNode() + partition.nodeCount();
            block0: for (long nodeId = fromNode; nodeId < toNode && (currentSelectionSize = selectionSize.get()) < this.samplingSize; ++nodeId) {
                int nodeDegree = graph.degree(nodeId);
                int probabilityFactor = threadLocalRandom.nextInt(maxDegree) + 1;
                if (probabilityFactor > nodeDegree) continue;
                while (true) {
                    long actualCurrentSelectionSize;
                    if (currentSelectionSize == (actualCurrentSelectionSize = selectionSize.compareAndExchange(currentSelectionSize, currentSelectionSize + 1L))) {
                        this.sampleSet.set(nodeId);
                        continue block0;
                    }
                    if (actualCurrentSelectionSize >= this.samplingSize) continue block0;
                    currentSelectionSize = actualCurrentSelectionSize;
                }
            }
        }).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(concurrency).tasks(tasks).executor(executorService).run();
        long actualSelectedNodes = selectionSize.get();
        if (actualSelectedNodes < this.samplingSize) {
            this.sampleSet.flip(0L, graph.nodeCount());
            while (actualSelectedNodes < this.samplingSize) {
                BitSetIterator iterator = this.sampleSet.iterator();
                int unselectedNode = iterator.nextSetBit();
                while (unselectedNode != -1 && actualSelectedNodes < this.samplingSize) {
                    if (random.nextDouble() >= 0.5) {
                        this.sampleSet.flip((long)unselectedNode);
                        ++actualSelectedNodes;
                    }
                    unselectedNode = iterator.nextSetBit();
                }
            }
            this.sampleSet.flip(0L, graph.nodeCount());
        }
    }
}

