/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import com.carrotsearch.hppc.LongArrayList;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayQueue;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;

class UnweightedForwardTraverser
implements ForwardTraverser {
    private final Graph graph;
    private final HugeObjectArray<LongArrayList> predecessors;
    private final HugeLongArrayStack backwardNodes;
    private final HugeLongArray sigma;
    private final HugeLongArrayQueue nodeQueue;
    private final HugeIntArray distances;
    private final TerminationFlag terminationFlag;

    static UnweightedForwardTraverser create(Graph graph, HugeObjectArray<LongArrayList> predecessors, HugeLongArrayStack backwardNodes, HugeLongArray sigma, TerminationFlag terminationFlag) {
        long nodeCount = graph.nodeCount();
        HugeIntArray distances = HugeIntArray.newArray((long)nodeCount);
        distances.fill(-1);
        HugeLongArrayQueue nodeQueue = HugeLongArrayQueue.newQueue((long)nodeCount);
        return new UnweightedForwardTraverser(graph, predecessors, backwardNodes, sigma, nodeQueue, distances, terminationFlag);
    }

    UnweightedForwardTraverser(Graph graph, HugeObjectArray<LongArrayList> predecessors, HugeLongArrayStack backwardNodes, HugeLongArray sigma, HugeLongArrayQueue nodeQueue, HugeIntArray distances, TerminationFlag terminationFlag) {
        this.graph = graph;
        this.predecessors = predecessors;
        this.backwardNodes = backwardNodes;
        this.sigma = sigma;
        this.nodeQueue = nodeQueue;
        this.distances = distances;
        this.terminationFlag = terminationFlag;
    }

    @Override
    public void traverse(long startNodeId) {
        this.nodeQueue.add(startNodeId);
        this.distances.set(startNodeId, 0);
        while (!this.nodeQueue.isEmpty() && this.terminationFlag.running()) {
            long node = this.nodeQueue.remove();
            this.backwardNodes.push(node);
            int nodeDistance = this.distances.get(node);
            this.graph.forEachRelationship(node, (source, target) -> {
                boolean firstTime;
                int targetDistance = nodeDistance + 1;
                boolean bl = firstTime = this.distances.get(target) < 0;
                if (firstTime) {
                    this.nodeQueue.add(target);
                    this.distances.set(target, targetDistance);
                }
                if (this.distances.get(target) == targetDistance) {
                    this.sigma.addTo(target, this.sigma.get(source));
                    this.appendPredecessor(target, source);
                }
                return true;
            });
        }
    }

    @Override
    public void clear() {
        this.distances.fill(-1);
    }

    private void appendPredecessor(long target, long node) {
        LongArrayList targetPredecessors = (LongArrayList)this.predecessors.get(target);
        if (null == targetPredecessors) {
            targetPredecessors = new LongArrayList();
            this.predecessors.set(target, (Object)targetPredecessors);
        }
        targetPredecessors.add(node);
    }
}

