/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.LongArrayList;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;

final class WeightedForwardTraverser
implements ForwardTraverser {
    private final Graph graph;
    private final TerminationFlag terminationFlag;
    private final HugeLongArrayStack backwardNodes;
    private final HugeLongArray sigma;
    private final HugeLongPriorityQueue nodeQueue;
    private final HugeObjectArray<LongArrayList> predecessors;
    private final BitSet visited;

    static WeightedForwardTraverser create(Graph graph, HugeObjectArray<LongArrayList> predecessors, HugeLongArrayStack backwardNodes, HugeLongArray sigma, TerminationFlag terminationFlag) {
        long nodeCount = graph.nodeCount();
        HugeLongPriorityQueue nodeQueue = HugeLongPriorityQueue.min((long)nodeCount);
        BitSet visited = new BitSet(nodeCount);
        return new WeightedForwardTraverser(graph, predecessors, backwardNodes, sigma, nodeQueue, visited, terminationFlag);
    }

    private WeightedForwardTraverser(Graph graph, HugeObjectArray<LongArrayList> predecessors, HugeLongArrayStack backwardNodes, HugeLongArray sigma, HugeLongPriorityQueue nodeQueue, BitSet visited, TerminationFlag terminationFlag) {
        this.graph = graph;
        this.predecessors = predecessors;
        this.backwardNodes = backwardNodes;
        this.sigma = sigma;
        this.nodeQueue = nodeQueue;
        this.visited = visited;
        this.terminationFlag = terminationFlag;
    }

    @Override
    public void traverse(long startNodeId) {
        this.nodeQueue.add(startNodeId, 0.0);
        while (!this.nodeQueue.isEmpty() && this.terminationFlag.running()) {
            long node = this.nodeQueue.top();
            this.backwardNodes.push(node);
            double nodeCost = this.nodeQueue.cost(node);
            this.nodeQueue.pop();
            this.visited.set(node);
            this.graph.forEachRelationship(node, 1.0, (source, target, weight) -> {
                double storedTargetCost;
                boolean firstTime;
                if (this.visited.get(target)) {
                    return true;
                }
                double targetCost = nodeCost + weight;
                boolean bl = firstTime = !this.nodeQueue.containsElement(target);
                if (firstTime) {
                    this.nodeQueue.add(target, targetCost);
                }
                if (Double.compare(targetCost, storedTargetCost = this.nodeQueue.cost(target)) == 0) {
                    this.sigma.addTo(target, this.sigma.get(source));
                    this.appendPredecessor(target, node);
                } else if (Double.compare(targetCost, storedTargetCost) < 0) {
                    this.nodeQueue.set(target, targetCost);
                    this.sigma.set(target, this.sigma.get(source));
                    LongArrayList targetPredecessors = (LongArrayList)this.predecessors.get(target);
                    targetPredecessors.clear();
                    targetPredecessors.add(source);
                }
                return true;
            });
        }
    }

    @Override
    public void clear() {
        this.visited.clear();
    }

    private void appendPredecessor(long target, long node) {
        LongArrayList targetPredecessors = (LongArrayList)this.predecessors.get(target);
        if (null == targetPredecessors) {
            targetPredecessors = new LongArrayList();
            this.predecessors.set(target, (Object)targetPredecessors);
        }
        targetPredecessors.add(node);
    }
}

