/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;

public class DegreeCentralityFactory<CONFIG extends DegreeCentralityConfig>
extends GraphAlgorithmFactory<DegreeCentrality, CONFIG> {
    private static final String DEGREE_CENTRALITY_TASK_NAME = "DegreeCentrality";

    public String taskName() {
        return DEGREE_CENTRALITY_TASK_NAME;
    }

    public DegreeCentrality build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return new DegreeCentrality(graph, Pools.DEFAULT, (DegreeCentralityConfig)configuration, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(DegreeCentrality.class);
        if (configuration.hasRelationshipWeightProperty()) {
            return builder.perNode("degree cache", HugeDoubleArray::memoryEstimation).build();
        }
        return builder.build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return DegreeCentralityFactory.degreeCentralityProgressTask(graph);
    }

    @NotNull
    public static Task degreeCentralityProgressTask(Graph graph) {
        return Tasks.leaf((String)DEGREE_CENTRALITY_TASK_NAME, (long)graph.nodeCount());
    }
}

