/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPBaseConfig;
import org.neo4j.gds.ml.core.features.FeatureExtraction;

public class FastRPFactory<CONFIG extends FastRPBaseConfig>
extends GraphAlgorithmFactory<FastRP, CONFIG> {
    public String taskName() {
        return "FastRP";
    }

    public FastRP build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, (Collection)configuration.featureProperties());
        return new FastRP(graph, (FastRPBaseConfig)configuration, featureExtractors, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return FastRP.memoryEstimation(configuration);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        ArrayList<Object> tasks = new ArrayList<Object>();
        tasks.add(Tasks.leaf((String)"Initialize random vectors", (long)graph.nodeCount()));
        if (Float.compare(config.nodeSelfInfluence().floatValue(), 0.0f) != 0) {
            tasks.add(Tasks.leaf((String)"Apply node self-influence", (long)graph.nodeCount()));
        }
        tasks.add(Tasks.iterativeFixed((String)"Propagate embeddings", () -> List.of(Tasks.leaf((String)"Propagate embeddings task", (long)graph.relationshipCount())), (int)config.iterationWeights().size()));
        return Tasks.task((String)this.taskName(), tasks);
    }
}

