/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.fastrp.FastRPStreamConfig;

public final class FastRPStreamConfigImpl
implements FastRPStreamConfig {
    private double propertyRatio;
    private List<Number> iterationWeights;
    private Number nodeSelfInfluence;
    private float normalizationStrength;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private int embeddingDimension;
    private Optional<String> relationshipWeightProperty;
    private List<String> featureProperties;
    private Optional<Long> randomSeed;

    public FastRPStreamConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.propertyRatio = config.getDouble("propertyRatio", FastRPStreamConfig.super.propertyRatio());
            CypherMapAccess.validateDoubleRange((String)"propertyRatio", (double)this.propertyRatio, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.iterationWeights = (List)CypherMapAccess.failOnNull((String)"iterationWeights", (Object)((List)config.getChecked("iterationWeights", FastRPStreamConfig.super.iterationWeights(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeSelfInfluence = (Number)CypherMapAccess.failOnNull((String)"nodeSelfInfluence", (Object)config.getNumber("nodeSelfInfluence", FastRPStreamConfig.super.nodeSelfInfluence()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.normalizationStrength = config.getNumber("normalizationStrength", (Number)Float.valueOf(FastRPStreamConfig.super.normalizationStrength())).floatValue();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)FastRPStreamConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)FastRPStreamConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", FastRPStreamConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", FastRPStreamConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", FastRPStreamConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)FastRPStreamConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.embeddingDimension = config.requireInt("embeddingDimension");
            CypherMapAccess.validateIntegerRange((String)"embeddingDimension", (int)this.embeddingDimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.featureProperties = (List)CypherMapAccess.failOnNull((String)"featureProperties", (Object)((List)config.getChecked("featureProperties", (Object)FastRPStreamConfig.super.featureProperties(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double propertyRatio() {
        return this.propertyRatio;
    }

    @Override
    public List<Number> iterationWeights() {
        return this.iterationWeights;
    }

    @Override
    public Number nodeSelfInfluence() {
        return this.nodeSelfInfluence;
    }

    @Override
    public float normalizationStrength() {
        return this.normalizationStrength;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateFeatureProperties(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("propertyRatio", "iterationWeights", "nodeSelfInfluence", "normalizationStrength", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "embeddingDimension", "relationshipWeightProperty", "featureProperties", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("propertyRatio", this.propertyRatio());
        map.put("iterationWeights", this.iterationWeights());
        map.put("nodeSelfInfluence", this.nodeSelfInfluence());
        map.put("normalizationStrength", Float.valueOf(this.normalizationStrength()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("embeddingDimension", this.embeddingDimension());
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        map.put("featureProperties", this.featureProperties());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<String> featureProperties() {
        return this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(FastRPStreamConfig baseConfig) {
            Builder builder = new Builder();
            builder.propertyRatio(baseConfig.propertyRatio());
            builder.iterationWeights(baseConfig.iterationWeights());
            builder.nodeSelfInfluence(baseConfig.nodeSelfInfluence());
            builder.normalizationStrength(baseConfig.normalizationStrength());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.embeddingDimension(baseConfig.embeddingDimension());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.featureProperties(baseConfig.featureProperties());
            builder.randomSeed(baseConfig.randomSeed());
            return builder;
        }

        public Builder propertyRatio(double propertyRatio) {
            this.config.put("propertyRatio", propertyRatio);
            return this;
        }

        public Builder iterationWeights(List<Number> iterationWeights) {
            this.config.put("iterationWeights", iterationWeights);
            return this;
        }

        public Builder nodeSelfInfluence(Number nodeSelfInfluence) {
            this.config.put("nodeSelfInfluence", nodeSelfInfluence);
            return this;
        }

        public Builder normalizationStrength(float normalizationStrength) {
            this.config.put("normalizationStrength", Float.valueOf(normalizationStrength));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder embeddingDimension(int embeddingDimension) {
            this.config.put("embeddingDimension", embeddingDimension);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder featureProperties(List<String> featureProperties) {
            this.config.put("featureProperties", featureProperties);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public FastRPStreamConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new FastRPStreamConfigImpl((CypherMapAccess)config);
        }
    }
}

