/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.fastrp.FastRPBaseConfig;

@Generated(from="FastRPBaseConfig", generator="Immutables")
public final class ImmutableFastRPBaseConfig
implements FastRPBaseConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final int embeddingDimension;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final List<String> featureProperties;
    private final Long randomSeed;
    private final transient int propertyDimension;
    private final double propertyRatio;
    private final List<Number> iterationWeights;
    private final Number nodeSelfInfluence;
    private final transient int iterations;
    private final float normalizationStrength;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFastRPBaseConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, Optional<String> relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(nodeLabels, true, false)));
        this.embeddingDimension = embeddingDimension;
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.featureProperties(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(iterationWeights, true, false)));
        this.initShim.nodeSelfInfluence(Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence"));
        this.initShim.normalizationStrength(normalizationStrength);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.initShim = null;
    }

    private ImmutableFastRPBaseConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(nodeLabels, true, false)));
        this.embeddingDimension = embeddingDimension;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.featureProperties(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed;
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(iterationWeights, true, false)));
        this.initShim.nodeSelfInfluence(Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence"));
        this.initShim.normalizationStrength(normalizationStrength);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.initShim = null;
    }

    private ImmutableFastRPBaseConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.embeddingDimension = builder.embeddingDimension;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.randomSeed = builder.randomSeed;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableFastRPBaseConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableFastRPBaseConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.featurePropertiesIsSet()) {
            this.initShim.featureProperties(builder.featureProperties == null ? Collections.emptyList() : ImmutableFastRPBaseConfig.createUnmodifiableList(true, builder.featureProperties));
        }
        if (builder.propertyRatioIsSet()) {
            this.initShim.propertyRatio(builder.propertyRatio);
        }
        if (builder.iterationWeightsIsSet()) {
            this.initShim.iterationWeights(builder.iterationWeights == null ? Collections.emptyList() : ImmutableFastRPBaseConfig.createUnmodifiableList(true, builder.iterationWeights));
        }
        if (builder.nodeSelfInfluence != null) {
            this.initShim.nodeSelfInfluence(builder.nodeSelfInfluence);
        }
        if (builder.normalizationStrengthIsSet()) {
            this.initShim.normalizationStrength(builder.normalizationStrength);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.initShim = null;
    }

    private ImmutableFastRPBaseConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, int embeddingDimension, String relationshipWeightProperty, List<String> featureProperties, Long randomSeed, double propertyRatio, List<Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.embeddingDimension = embeddingDimension;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.featureProperties(featureProperties);
        this.randomSeed = randomSeed;
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(iterationWeights);
        this.initShim.nodeSelfInfluence(nodeSelfInfluence);
        this.initShim.normalizationStrength(normalizationStrength);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return FastRPBaseConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return FastRPBaseConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return FastRPBaseConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return FastRPBaseConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return FastRPBaseConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return FastRPBaseConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return FastRPBaseConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return FastRPBaseConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return FastRPBaseConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return FastRPBaseConfig.super.hasRelationshipWeightProperty();
    }

    private List<String> featurePropertiesInitialize() {
        return FastRPBaseConfig.super.featureProperties();
    }

    private int propertyDimensionInitialize() {
        return FastRPBaseConfig.super.propertyDimension();
    }

    private double propertyRatioInitialize() {
        return FastRPBaseConfig.super.propertyRatio();
    }

    private List<Number> iterationWeightsInitialize() {
        return FastRPBaseConfig.super.iterationWeights();
    }

    private Number nodeSelfInfluenceInitialize() {
        return FastRPBaseConfig.super.nodeSelfInfluence();
    }

    private int iterationsInitialize() {
        return FastRPBaseConfig.super.iterations();
    }

    private float normalizationStrengthInitialize() {
        return FastRPBaseConfig.super.normalizationStrength();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public List<String> featureProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureProperties() : this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int propertyDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyDimension() : this.propertyDimension;
    }

    @Override
    public double propertyRatio() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyRatio() : this.propertyRatio;
    }

    @Override
    public List<Number> iterationWeights() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterationWeights() : this.iterationWeights;
    }

    @Override
    public Number nodeSelfInfluence() {
        InitShim shim = this.initShim;
        return shim != null ? (Number)shim.nodeSelfInfluence() : (Number)this.nodeSelfInfluence;
    }

    @Override
    public int iterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterations() : this.iterations;
    }

    @Override
    public float normalizationStrength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizationStrength() : this.normalizationStrength;
    }

    public final ImmutableFastRPBaseConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(elements, true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(elements, true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, newValue, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, value, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withFeatureProperties(String ... elements) {
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, newValue, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withFeatureProperties(Iterable<String> elements) {
        if (this.featureProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(elements, true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, newValue, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, newValue, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, value, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withPropertyRatio(double value) {
        if (Double.doubleToLongBits(this.propertyRatio) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, value, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withIterationWeights(Number ... elements) {
        List<Number> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, newValue, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withIterationWeights(Iterable<? extends Number> elements) {
        if (this.iterationWeights == elements) {
            return this;
        }
        List<Number> newValue = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(elements, true, false));
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, newValue, this.nodeSelfInfluence, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withNodeSelfInfluence(Number value) {
        if (this.nodeSelfInfluence == value) {
            return this;
        }
        Number newValue = Objects.requireNonNull(value, "nodeSelfInfluence");
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, newValue, this.normalizationStrength));
    }

    public final ImmutableFastRPBaseConfig withNormalizationStrength(float value) {
        if (Float.floatToIntBits(this.normalizationStrength) == Float.floatToIntBits(value)) {
            return this;
        }
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFastRPBaseConfig && this.equalTo((ImmutableFastRPBaseConfig)another);
    }

    private boolean equalTo(ImmutableFastRPBaseConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.embeddingDimension == another.embeddingDimension && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.featureProperties.equals(another.featureProperties) && Objects.equals(this.randomSeed, another.randomSeed) && this.propertyDimension == another.propertyDimension && Double.doubleToLongBits(this.propertyRatio) == Double.doubleToLongBits(another.propertyRatio) && this.iterationWeights.equals(another.iterationWeights) && this.nodeSelfInfluence.equals(another.nodeSelfInfluence) && this.iterations == another.iterations && Float.floatToIntBits(this.normalizationStrength) == Float.floatToIntBits(another.normalizationStrength);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + this.featureProperties.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.propertyDimension;
        h += (h << 5) + Double.hashCode(this.propertyRatio);
        h += (h << 5) + this.iterationWeights.hashCode();
        h += (h << 5) + this.nodeSelfInfluence.hashCode();
        h += (h << 5) + this.iterations;
        h += (h << 5) + Float.hashCode(this.normalizationStrength);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FastRPBaseConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("featureProperties=").append(this.featureProperties);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("propertyDimension=").append(this.propertyDimension);
        builder.append(", ");
        builder.append("propertyRatio=").append(this.propertyRatio);
        builder.append(", ");
        builder.append("iterationWeights=").append(this.iterationWeights);
        builder.append(", ");
        builder.append("nodeSelfInfluence=").append(this.nodeSelfInfluence);
        builder.append(", ");
        builder.append("iterations=").append(this.iterations);
        builder.append(", ");
        builder.append("normalizationStrength=").append(this.normalizationStrength);
        return builder.append("}").toString();
    }

    public static FastRPBaseConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, int embeddingDimension, Optional<String> relationshipWeightProperty, List<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, List<Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        return ImmutableFastRPBaseConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength);
    }

    public static FastRPBaseConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, Optional<String> relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength));
    }

    public static FastRPBaseConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength) {
        return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength));
    }

    private static ImmutableFastRPBaseConfig validate(ImmutableFastRPBaseConfig instance) {
        instance.validate();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static FastRPBaseConfig copyOf(FastRPBaseConfig instance) {
        if (instance instanceof ImmutableFastRPBaseConfig) {
            return (ImmutableFastRPBaseConfig)instance;
        }
        return ImmutableFastRPBaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FastRPBaseConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMBEDDING_DIMENSION = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_FEATURE_PROPERTIES = 64L;
        private static final long OPT_BIT_PROPERTY_RATIO = 128L;
        private static final long OPT_BIT_ITERATION_WEIGHTS = 256L;
        private static final long OPT_BIT_NORMALIZATION_STRENGTH = 512L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private int embeddingDimension;
        private String relationshipWeightProperty;
        private List<String> featureProperties = null;
        private Long randomSeed;
        private double propertyRatio;
        private List<Number> iterationWeights = null;
        private Number nodeSelfInfluence;
        private float normalizationStrength;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FastRPBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FeaturePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            Optional relationshipWeightPropertyOptional;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof FastRPBaseConfig) {
                instance = (FastRPBaseConfig)object;
                this.addAllIterationWeights(instance.iterationWeights());
                this.nodeSelfInfluence(instance.nodeSelfInfluence());
                this.propertyRatio(instance.propertyRatio());
                this.normalizationStrength(instance.normalizationStrength());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof FeaturePropertiesConfig) {
                instance = (FeaturePropertiesConfig)object;
                this.addAllFeatureProperties(instance.featureProperties());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                this.embeddingDimension(instance.embeddingDimension());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder addFeatureProperty(String element) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addFeatureProperties(String ... elements) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder featureProperties(Iterable<String> elements) {
            this.featureProperties = new ArrayList<String>();
            return this.addAllFeatureProperties(elements);
        }

        public final Builder addAllFeatureProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "featureProperties element");
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder propertyRatio(double propertyRatio) {
            this.propertyRatio = propertyRatio;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addIterationWeight(Number element) {
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            this.iterationWeights.add(Objects.requireNonNull(element, "iterationWeights element"));
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder addIterationWeights(Number ... elements) {
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            for (Number element : elements) {
                this.iterationWeights.add(Objects.requireNonNull(element, "iterationWeights element"));
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder iterationWeights(Iterable<? extends Number> elements) {
            this.iterationWeights = new ArrayList<Number>();
            return this.addAllIterationWeights(elements);
        }

        public final Builder addAllIterationWeights(Iterable<? extends Number> elements) {
            Objects.requireNonNull(elements, "iterationWeights element");
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            for (Number number : elements) {
                this.iterationWeights.add(Objects.requireNonNull(number, "iterationWeights element"));
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder nodeSelfInfluence(Number nodeSelfInfluence) {
            this.nodeSelfInfluence = Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence");
            return this;
        }

        public final Builder normalizationStrength(float normalizationStrength) {
            this.normalizationStrength = normalizationStrength;
            this.optBits |= 0x200L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.embeddingDimension = 0;
            this.relationshipWeightProperty = null;
            if (this.featureProperties != null) {
                this.featureProperties.clear();
            }
            this.randomSeed = null;
            this.propertyRatio = 0.0;
            if (this.iterationWeights != null) {
                this.iterationWeights.clear();
            }
            this.nodeSelfInfluence = null;
            this.normalizationStrength = 0.0f;
            return this;
        }

        public FastRPBaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFastRPBaseConfig.validate(new ImmutableFastRPBaseConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean featurePropertiesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean propertyRatioIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean iterationWeightsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean normalizationStrengthIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("embeddingDimension");
            }
            return "Cannot build FastRPBaseConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FastRPBaseConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte featurePropertiesBuildStage = 0;
        private List<String> featureProperties;
        private byte propertyDimensionBuildStage = 0;
        private int propertyDimension;
        private byte propertyRatioBuildStage = 0;
        private double propertyRatio;
        private byte iterationWeightsBuildStage = 0;
        private List<Number> iterationWeights;
        private byte nodeSelfInfluenceBuildStage = 0;
        private Number nodeSelfInfluence;
        private byte iterationsBuildStage = 0;
        private int iterations;
        private byte normalizationStrengthBuildStage = 0;
        private float normalizationStrength;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableFastRPBaseConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableFastRPBaseConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableFastRPBaseConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableFastRPBaseConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableFastRPBaseConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableFastRPBaseConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableFastRPBaseConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(ImmutableFastRPBaseConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(ImmutableFastRPBaseConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableFastRPBaseConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        List<String> featureProperties() {
            if (this.featurePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featurePropertiesBuildStage == 0) {
                this.featurePropertiesBuildStage = (byte)-1;
                this.featureProperties = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(ImmutableFastRPBaseConfig.this.featurePropertiesInitialize(), true, false));
                this.featurePropertiesBuildStage = 1;
            }
            return this.featureProperties;
        }

        void featureProperties(List<String> featureProperties) {
            this.featureProperties = featureProperties;
            this.featurePropertiesBuildStage = 1;
        }

        int propertyDimension() {
            if (this.propertyDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyDimensionBuildStage == 0) {
                this.propertyDimensionBuildStage = (byte)-1;
                this.propertyDimension = ImmutableFastRPBaseConfig.this.propertyDimensionInitialize();
                this.propertyDimensionBuildStage = 1;
            }
            return this.propertyDimension;
        }

        double propertyRatio() {
            if (this.propertyRatioBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyRatioBuildStage == 0) {
                this.propertyRatioBuildStage = (byte)-1;
                this.propertyRatio = ImmutableFastRPBaseConfig.this.propertyRatioInitialize();
                this.propertyRatioBuildStage = 1;
            }
            return this.propertyRatio;
        }

        void propertyRatio(double propertyRatio) {
            this.propertyRatio = propertyRatio;
            this.propertyRatioBuildStage = 1;
        }

        List<Number> iterationWeights() {
            if (this.iterationWeightsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationWeightsBuildStage == 0) {
                this.iterationWeightsBuildStage = (byte)-1;
                this.iterationWeights = ImmutableFastRPBaseConfig.createUnmodifiableList(false, ImmutableFastRPBaseConfig.createSafeList(ImmutableFastRPBaseConfig.this.iterationWeightsInitialize(), true, false));
                this.iterationWeightsBuildStage = 1;
            }
            return this.iterationWeights;
        }

        void iterationWeights(List<Number> iterationWeights) {
            this.iterationWeights = iterationWeights;
            this.iterationWeightsBuildStage = 1;
        }

        Number nodeSelfInfluence() {
            if (this.nodeSelfInfluenceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeSelfInfluenceBuildStage == 0) {
                this.nodeSelfInfluenceBuildStage = (byte)-1;
                this.nodeSelfInfluence = Objects.requireNonNull(ImmutableFastRPBaseConfig.this.nodeSelfInfluenceInitialize(), "nodeSelfInfluence");
                this.nodeSelfInfluenceBuildStage = 1;
            }
            return this.nodeSelfInfluence;
        }

        void nodeSelfInfluence(Number nodeSelfInfluence) {
            this.nodeSelfInfluence = nodeSelfInfluence;
            this.nodeSelfInfluenceBuildStage = 1;
        }

        int iterations() {
            if (this.iterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationsBuildStage == 0) {
                this.iterationsBuildStage = (byte)-1;
                this.iterations = ImmutableFastRPBaseConfig.this.iterationsInitialize();
                this.iterationsBuildStage = 1;
            }
            return this.iterations;
        }

        float normalizationStrength() {
            if (this.normalizationStrengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizationStrengthBuildStage == 0) {
                this.normalizationStrengthBuildStage = (byte)-1;
                this.normalizationStrength = ImmutableFastRPBaseConfig.this.normalizationStrengthInitialize();
                this.normalizationStrengthBuildStage = 1;
            }
            return this.normalizationStrength;
        }

        void normalizationStrength(float normalizationStrength) {
            this.normalizationStrength = normalizationStrength;
            this.normalizationStrengthBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.featurePropertiesBuildStage == -1) {
                attributes.add("featureProperties");
            }
            if (this.propertyDimensionBuildStage == -1) {
                attributes.add("propertyDimension");
            }
            if (this.propertyRatioBuildStage == -1) {
                attributes.add("propertyRatio");
            }
            if (this.iterationWeightsBuildStage == -1) {
                attributes.add("iterationWeights");
            }
            if (this.nodeSelfInfluenceBuildStage == -1) {
                attributes.add("nodeSelfInfluence");
            }
            if (this.iterationsBuildStage == -1) {
                attributes.add("iterations");
            }
            if (this.normalizationStrengthBuildStage == -1) {
                attributes.add("normalizationStrength");
            }
            return "Cannot build FastRPBaseConfig, attribute initializers form cycle " + attributes;
        }
    }
}

