/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.GraphSageModelTrainer;

@Generated(from="GraphSageModelTrainer.EpochResult", generator="Immutables")
public final class ImmutableEpochResult
implements GraphSageModelTrainer.EpochResult {
    private final boolean converged;
    private final List<Double> losses;

    private ImmutableEpochResult(boolean converged, Iterable<Double> losses) {
        this.converged = converged;
        this.losses = ImmutableEpochResult.createUnmodifiableList(false, ImmutableEpochResult.createSafeList(losses, true, false));
    }

    private ImmutableEpochResult(ImmutableEpochResult original, boolean converged, List<Double> losses) {
        this.converged = converged;
        this.losses = losses;
    }

    @Override
    public boolean converged() {
        return this.converged;
    }

    @Override
    public List<Double> losses() {
        return this.losses;
    }

    public final ImmutableEpochResult withConverged(boolean value) {
        if (this.converged == value) {
            return this;
        }
        return new ImmutableEpochResult(this, value, this.losses);
    }

    public final ImmutableEpochResult withLosses(double ... elements) {
        ArrayList<Double> wrappedList = new ArrayList<Double>(elements.length);
        for (double element : elements) {
            wrappedList.add(element);
        }
        List<Double> newValue = ImmutableEpochResult.createUnmodifiableList(false, wrappedList);
        return new ImmutableEpochResult(this, this.converged, newValue);
    }

    public final ImmutableEpochResult withLosses(Iterable<Double> elements) {
        if (this.losses == elements) {
            return this;
        }
        List<Double> newValue = ImmutableEpochResult.createUnmodifiableList(false, ImmutableEpochResult.createSafeList(elements, true, false));
        return new ImmutableEpochResult(this, this.converged, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEpochResult && this.equalTo((ImmutableEpochResult)another);
    }

    private boolean equalTo(ImmutableEpochResult another) {
        return this.converged == another.converged && this.losses.equals(another.losses);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.converged);
        h += (h << 5) + this.losses.hashCode();
        return h;
    }

    public String toString() {
        return "EpochResult{converged=" + this.converged + ", losses=" + this.losses + "}";
    }

    public static GraphSageModelTrainer.EpochResult of(boolean converged, List<Double> losses) {
        return ImmutableEpochResult.of(converged, losses);
    }

    public static GraphSageModelTrainer.EpochResult of(boolean converged, Iterable<Double> losses) {
        return new ImmutableEpochResult(converged, losses);
    }

    static GraphSageModelTrainer.EpochResult copyOf(GraphSageModelTrainer.EpochResult instance) {
        if (instance instanceof ImmutableEpochResult) {
            return (ImmutableEpochResult)instance;
        }
        return ImmutableEpochResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphSageModelTrainer.EpochResult", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_CONVERGED = 1L;
        private long initBits = 1L;
        private boolean converged;
        private List<Double> losses = null;

        private Builder() {
        }

        public final Builder from(ImmutableEpochResult instance) {
            return this.from((GraphSageModelTrainer.EpochResult)instance);
        }

        final Builder from(GraphSageModelTrainer.EpochResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.converged(instance.converged());
            this.addAllLosses(instance.losses());
            return this;
        }

        public final Builder converged(boolean converged) {
            this.converged = converged;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLosse(double element) {
            if (this.losses == null) {
                this.losses = new ArrayList<Double>();
            }
            this.losses.add(element);
            return this;
        }

        public final Builder addLosses(double ... elements) {
            if (this.losses == null) {
                this.losses = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.losses.add(element);
            }
            return this;
        }

        public final Builder losses(Iterable<Double> elements) {
            this.losses = new ArrayList<Double>();
            return this.addAllLosses(elements);
        }

        public final Builder addAllLosses(Iterable<Double> elements) {
            Objects.requireNonNull(elements, "losses element");
            if (this.losses == null) {
                this.losses = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.losses.add(Objects.requireNonNull(Double.valueOf(element), "losses element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.converged = false;
            if (this.losses != null) {
                this.losses.clear();
            }
            return this;
        }

        public GraphSageModelTrainer.EpochResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEpochResult(null, this.converged, this.losses == null ? Collections.emptyList() : ImmutableEpochResult.createUnmodifiableList(true, this.losses));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("converged");
            }
            return "Cannot build EpochResult, some of required attributes are not set " + attributes;
        }
    }
}

