/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.GraphSageModelTrainer;

@Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
public final class ImmutableGraphSageTrainMetrics
implements GraphSageModelTrainer.GraphSageTrainMetrics {
    private final transient List<Double> epochLosses;
    private final List<List<Double>> iterationLossPerEpoch;
    private final boolean didConverge;
    private final transient int ranEpochs;
    private final transient List<Integer> ranIterationsPerEpoch;
    private final transient Map<String, Object> toMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphSageTrainMetrics(Iterable<? extends List<Double>> iterationLossPerEpoch, boolean didConverge) {
        this.iterationLossPerEpoch = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, ImmutableGraphSageTrainMetrics.createSafeList(iterationLossPerEpoch, true, false));
        this.didConverge = didConverge;
        this.epochLosses = this.initShim.epochLosses();
        this.ranEpochs = this.initShim.ranEpochs();
        this.ranIterationsPerEpoch = this.initShim.ranIterationsPerEpoch();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainMetrics(ImmutableGraphSageTrainMetrics original, List<List<Double>> iterationLossPerEpoch, boolean didConverge) {
        this.iterationLossPerEpoch = iterationLossPerEpoch;
        this.didConverge = didConverge;
        this.epochLosses = this.initShim.epochLosses();
        this.ranEpochs = this.initShim.ranEpochs();
        this.ranIterationsPerEpoch = this.initShim.ranIterationsPerEpoch();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private List<Double> epochLossesInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.epochLosses();
    }

    private int ranEpochsInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.ranEpochs();
    }

    private List<Integer> ranIterationsPerEpochInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.ranIterationsPerEpoch();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.toMap();
    }

    @Override
    public List<Double> epochLosses() {
        InitShim shim = this.initShim;
        return shim != null ? shim.epochLosses() : this.epochLosses;
    }

    @Override
    public List<List<Double>> iterationLossPerEpoch() {
        return this.iterationLossPerEpoch;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    @Override
    public int ranEpochs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ranEpochs() : this.ranEpochs;
    }

    @Override
    public List<Integer> ranIterationsPerEpoch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ranIterationsPerEpoch() : this.ranIterationsPerEpoch;
    }

    @Override
    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @SafeVarargs
    public final ImmutableGraphSageTrainMetrics withIterationLossPerEpoch(List<Double> ... elements) {
        List<List<Double>> newValue = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, ImmutableGraphSageTrainMetrics.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGraphSageTrainMetrics(this, newValue, this.didConverge);
    }

    public final ImmutableGraphSageTrainMetrics withIterationLossPerEpoch(Iterable<? extends List<Double>> elements) {
        if (this.iterationLossPerEpoch == elements) {
            return this;
        }
        List<List<Double>> newValue = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, ImmutableGraphSageTrainMetrics.createSafeList(elements, true, false));
        return new ImmutableGraphSageTrainMetrics(this, newValue, this.didConverge);
    }

    public final ImmutableGraphSageTrainMetrics withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutableGraphSageTrainMetrics(this, this.iterationLossPerEpoch, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageTrainMetrics && this.equalTo((ImmutableGraphSageTrainMetrics)another);
    }

    private boolean equalTo(ImmutableGraphSageTrainMetrics another) {
        return this.epochLosses.equals(another.epochLosses) && this.iterationLossPerEpoch.equals(another.iterationLossPerEpoch) && this.didConverge == another.didConverge && this.ranEpochs == another.ranEpochs && this.ranIterationsPerEpoch.equals(another.ranIterationsPerEpoch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.epochLosses.hashCode();
        h += (h << 5) + this.iterationLossPerEpoch.hashCode();
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        h += (h << 5) + this.ranEpochs;
        h += (h << 5) + this.ranIterationsPerEpoch.hashCode();
        return h;
    }

    public String toString() {
        return "GraphSageTrainMetrics{epochLosses=" + this.epochLosses + ", iterationLossPerEpoch=" + this.iterationLossPerEpoch + ", didConverge=" + this.didConverge + ", ranEpochs=" + this.ranEpochs + ", ranIterationsPerEpoch=" + this.ranIterationsPerEpoch + "}";
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics of(List<List<Double>> iterationLossPerEpoch, boolean didConverge) {
        return ImmutableGraphSageTrainMetrics.of(iterationLossPerEpoch, didConverge);
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics of(Iterable<? extends List<Double>> iterationLossPerEpoch, boolean didConverge) {
        return new ImmutableGraphSageTrainMetrics(iterationLossPerEpoch, didConverge);
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics copyOf(GraphSageModelTrainer.GraphSageTrainMetrics instance) {
        if (instance instanceof ImmutableGraphSageTrainMetrics) {
            return (ImmutableGraphSageTrainMetrics)instance;
        }
        return ImmutableGraphSageTrainMetrics.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DID_CONVERGE = 1L;
        private long initBits = 1L;
        private List<List<Double>> iterationLossPerEpoch = null;
        private boolean didConverge;

        private Builder() {
        }

        public final Builder from(GraphSageModelTrainer.GraphSageTrainMetrics instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllIterationLossPerEpoch(instance.iterationLossPerEpoch());
            this.didConverge(instance.didConverge());
            return this;
        }

        public final Builder addIterationLossPerEpoch(List<Double> element) {
            if (this.iterationLossPerEpoch == null) {
                this.iterationLossPerEpoch = new ArrayList<List<Double>>();
            }
            this.iterationLossPerEpoch.add(Objects.requireNonNull(element, "iterationLossPerEpoch element"));
            return this;
        }

        @SafeVarargs
        public final Builder addIterationLossPerEpoch(List<Double> ... elements) {
            if (this.iterationLossPerEpoch == null) {
                this.iterationLossPerEpoch = new ArrayList<List<Double>>();
            }
            for (List<Double> element : elements) {
                this.iterationLossPerEpoch.add(Objects.requireNonNull(element, "iterationLossPerEpoch element"));
            }
            return this;
        }

        public final Builder iterationLossPerEpoch(Iterable<? extends List<Double>> elements) {
            this.iterationLossPerEpoch = new ArrayList<List<Double>>();
            return this.addAllIterationLossPerEpoch(elements);
        }

        public final Builder addAllIterationLossPerEpoch(Iterable<? extends List<Double>> elements) {
            Objects.requireNonNull(elements, "iterationLossPerEpoch element");
            if (this.iterationLossPerEpoch == null) {
                this.iterationLossPerEpoch = new ArrayList<List<Double>>();
            }
            for (List<Double> list : elements) {
                this.iterationLossPerEpoch.add(Objects.requireNonNull(list, "iterationLossPerEpoch element"));
            }
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            if (this.iterationLossPerEpoch != null) {
                this.iterationLossPerEpoch.clear();
            }
            this.didConverge = false;
            return this;
        }

        public GraphSageModelTrainer.GraphSageTrainMetrics build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphSageTrainMetrics(null, this.iterationLossPerEpoch == null ? Collections.emptyList() : ImmutableGraphSageTrainMetrics.createUnmodifiableList(true, this.iterationLossPerEpoch), this.didConverge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("didConverge");
            }
            return "Cannot build GraphSageTrainMetrics, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
    private final class InitShim {
        private byte epochLossesBuildStage = 0;
        private List<Double> epochLosses;
        private byte ranEpochsBuildStage = 0;
        private int ranEpochs;
        private byte ranIterationsPerEpochBuildStage = 0;
        private List<Integer> ranIterationsPerEpoch;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;

        private InitShim() {
        }

        List<Double> epochLosses() {
            if (this.epochLossesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.epochLossesBuildStage == 0) {
                this.epochLossesBuildStage = (byte)-1;
                this.epochLosses = Objects.requireNonNull(ImmutableGraphSageTrainMetrics.this.epochLossesInitialize(), "epochLosses");
                this.epochLossesBuildStage = 1;
            }
            return this.epochLosses;
        }

        int ranEpochs() {
            if (this.ranEpochsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ranEpochsBuildStage == 0) {
                this.ranEpochsBuildStage = (byte)-1;
                this.ranEpochs = ImmutableGraphSageTrainMetrics.this.ranEpochsInitialize();
                this.ranEpochsBuildStage = 1;
            }
            return this.ranEpochs;
        }

        List<Integer> ranIterationsPerEpoch() {
            if (this.ranIterationsPerEpochBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ranIterationsPerEpochBuildStage == 0) {
                this.ranIterationsPerEpochBuildStage = (byte)-1;
                this.ranIterationsPerEpoch = Objects.requireNonNull(ImmutableGraphSageTrainMetrics.this.ranIterationsPerEpochInitialize(), "ranIterationsPerEpoch");
                this.ranIterationsPerEpochBuildStage = 1;
            }
            return this.ranIterationsPerEpoch;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphSageTrainMetrics.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.epochLossesBuildStage == -1) {
                attributes.add("epochLosses");
            }
            if (this.ranEpochsBuildStage == -1) {
                attributes.add("ranEpochs");
            }
            if (this.ranIterationsPerEpochBuildStage == -1) {
                attributes.add("ranIterationsPerEpoch");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            return "Cannot build GraphSageTrainMetrics, attribute initializers form cycle " + attributes;
        }
    }
}

