/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.ActivationFunction;
import org.neo4j.gds.embeddings.graphsage.Aggregator;
import org.neo4j.gds.embeddings.graphsage.LayerConfig;

@Generated(from="LayerConfig", generator="Immutables")
public final class ImmutableLayerConfig
implements LayerConfig {
    private final int rows;
    private final int cols;
    private final int sampleSize;
    private final long randomSeed;
    private final Integer bias;
    private final Aggregator.AggregatorType aggregatorType;
    private final ActivationFunction activationFunction;

    private ImmutableLayerConfig(int rows, int cols, int sampleSize, long randomSeed, Optional<Integer> bias, Aggregator.AggregatorType aggregatorType, ActivationFunction activationFunction) {
        this.rows = rows;
        this.cols = cols;
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.bias = bias.orElse(null);
        this.aggregatorType = Objects.requireNonNull(aggregatorType, "aggregatorType");
        this.activationFunction = Objects.requireNonNull(activationFunction, "activationFunction");
    }

    private ImmutableLayerConfig(int rows, int cols, int sampleSize, long randomSeed, Integer bias, Aggregator.AggregatorType aggregatorType, ActivationFunction activationFunction) {
        this.rows = rows;
        this.cols = cols;
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.bias = bias;
        this.aggregatorType = Objects.requireNonNull(aggregatorType, "aggregatorType");
        this.activationFunction = Objects.requireNonNull(activationFunction, "activationFunction");
    }

    private ImmutableLayerConfig(ImmutableLayerConfig original, int rows, int cols, int sampleSize, long randomSeed, Integer bias, Aggregator.AggregatorType aggregatorType, ActivationFunction activationFunction) {
        this.rows = rows;
        this.cols = cols;
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.bias = bias;
        this.aggregatorType = aggregatorType;
        this.activationFunction = activationFunction;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int sampleSize() {
        return this.sampleSize;
    }

    @Override
    public long randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Optional<Integer> bias() {
        return Optional.ofNullable(this.bias);
    }

    @Override
    public Aggregator.AggregatorType aggregatorType() {
        return this.aggregatorType;
    }

    @Override
    public ActivationFunction activationFunction() {
        return this.activationFunction;
    }

    public final ImmutableLayerConfig withRows(int value) {
        if (this.rows == value) {
            return this;
        }
        return new ImmutableLayerConfig(this, value, this.cols, this.sampleSize, this.randomSeed, this.bias, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withCols(int value) {
        if (this.cols == value) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, value, this.sampleSize, this.randomSeed, this.bias, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withSampleSize(int value) {
        if (this.sampleSize == value) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, value, this.randomSeed, this.bias, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withRandomSeed(long value) {
        if (this.randomSeed == value) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, this.sampleSize, value, this.bias, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withBias(Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.bias, newValue)) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, this.sampleSize, this.randomSeed, newValue, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withBias(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.bias, value)) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, this.sampleSize, this.randomSeed, value, this.aggregatorType, this.activationFunction);
    }

    public final ImmutableLayerConfig withAggregatorType(Aggregator.AggregatorType value) {
        if (this.aggregatorType == value) {
            return this;
        }
        Aggregator.AggregatorType newValue = Objects.requireNonNull(value, "aggregatorType");
        if (this.aggregatorType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, this.sampleSize, this.randomSeed, this.bias, newValue, this.activationFunction);
    }

    public final ImmutableLayerConfig withActivationFunction(ActivationFunction value) {
        if (this.activationFunction == value) {
            return this;
        }
        ActivationFunction newValue = Objects.requireNonNull(value, "activationFunction");
        if (this.activationFunction.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableLayerConfig(this, this.rows, this.cols, this.sampleSize, this.randomSeed, this.bias, this.aggregatorType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLayerConfig && this.equalTo((ImmutableLayerConfig)another);
    }

    private boolean equalTo(ImmutableLayerConfig another) {
        return this.rows == another.rows && this.cols == another.cols && this.sampleSize == another.sampleSize && this.randomSeed == another.randomSeed && Objects.equals(this.bias, another.bias) && this.aggregatorType.equals((Object)another.aggregatorType) && this.activationFunction.equals((Object)another.activationFunction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.rows;
        h += (h << 5) + this.cols;
        h += (h << 5) + this.sampleSize;
        h += (h << 5) + Long.hashCode(this.randomSeed);
        h += (h << 5) + Objects.hashCode(this.bias);
        h += (h << 5) + this.aggregatorType.hashCode();
        h += (h << 5) + this.activationFunction.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LayerConfig{");
        builder.append("rows=").append(this.rows);
        builder.append(", ");
        builder.append("cols=").append(this.cols);
        builder.append(", ");
        builder.append("sampleSize=").append(this.sampleSize);
        builder.append(", ");
        builder.append("randomSeed=").append(this.randomSeed);
        if (this.bias != null) {
            builder.append(", ");
            builder.append("bias=").append(this.bias);
        }
        builder.append(", ");
        builder.append("aggregatorType=").append((Object)this.aggregatorType);
        builder.append(", ");
        builder.append("activationFunction=").append((Object)this.activationFunction);
        return builder.append("}").toString();
    }

    public static LayerConfig of(int rows, int cols, int sampleSize, long randomSeed, Optional<Integer> bias, Aggregator.AggregatorType aggregatorType, ActivationFunction activationFunction) {
        return new ImmutableLayerConfig(rows, cols, sampleSize, randomSeed, bias, aggregatorType, activationFunction);
    }

    public static LayerConfig of(int rows, int cols, int sampleSize, long randomSeed, Integer bias, Aggregator.AggregatorType aggregatorType, ActivationFunction activationFunction) {
        return new ImmutableLayerConfig(rows, cols, sampleSize, randomSeed, bias, aggregatorType, activationFunction);
    }

    public static LayerConfig copyOf(LayerConfig instance) {
        if (instance instanceof ImmutableLayerConfig) {
            return (ImmutableLayerConfig)instance;
        }
        return ImmutableLayerConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LayerConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ROWS = 1L;
        private static final long INIT_BIT_COLS = 2L;
        private static final long INIT_BIT_SAMPLE_SIZE = 4L;
        private static final long INIT_BIT_RANDOM_SEED = 8L;
        private static final long INIT_BIT_AGGREGATOR_TYPE = 16L;
        private static final long INIT_BIT_ACTIVATION_FUNCTION = 32L;
        private long initBits = 63L;
        private int rows;
        private int cols;
        private int sampleSize;
        private long randomSeed;
        private Integer bias;
        private Aggregator.AggregatorType aggregatorType;
        private ActivationFunction activationFunction;

        private Builder() {
        }

        public final Builder from(LayerConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.rows(instance.rows());
            this.cols(instance.cols());
            this.sampleSize(instance.sampleSize());
            this.randomSeed(instance.randomSeed());
            Optional<Integer> biasOptional = instance.bias();
            if (biasOptional.isPresent()) {
                this.bias(biasOptional);
            }
            this.aggregatorType(instance.aggregatorType());
            this.activationFunction(instance.activationFunction());
            return this;
        }

        public final Builder rows(int rows) {
            this.rows = rows;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder cols(int cols) {
            this.cols = cols;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder randomSeed(long randomSeed) {
            this.randomSeed = randomSeed;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder bias(Integer bias) {
            this.bias = bias;
            return this;
        }

        public final Builder bias(Optional<Integer> bias) {
            this.bias = bias.orElse(null);
            return this;
        }

        public final Builder aggregatorType(Aggregator.AggregatorType aggregatorType) {
            this.aggregatorType = Objects.requireNonNull(aggregatorType, "aggregatorType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = Objects.requireNonNull(activationFunction, "activationFunction");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 63L;
            this.rows = 0;
            this.cols = 0;
            this.sampleSize = 0;
            this.randomSeed = 0L;
            this.bias = null;
            this.aggregatorType = null;
            this.activationFunction = null;
            return this;
        }

        public LayerConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLayerConfig(null, this.rows, this.cols, this.sampleSize, this.randomSeed, this.bias, this.aggregatorType, this.activationFunction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rows");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cols");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sampleSize");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("randomSeed");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("aggregatorType");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("activationFunction");
            }
            return "Cannot build LayerConfig, some of required attributes are not set " + attributes;
        }
    }
}

