/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.GraphSageModelTrainer;
import org.neo4j.gds.embeddings.graphsage.Layer;

@Generated(from="GraphSageModelTrainer.ModelTrainResult", generator="Immutables")
public final class ImmutableModelTrainResult
implements GraphSageModelTrainer.ModelTrainResult {
    private final GraphSageModelTrainer.GraphSageTrainMetrics metrics;
    private final Layer[] layers;

    private ImmutableModelTrainResult(GraphSageModelTrainer.GraphSageTrainMetrics metrics, Layer[] layers) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.layers = (Layer[])layers.clone();
    }

    private ImmutableModelTrainResult(ImmutableModelTrainResult original, GraphSageModelTrainer.GraphSageTrainMetrics metrics, Layer[] layers) {
        this.metrics = metrics;
        this.layers = layers;
    }

    @Override
    public GraphSageModelTrainer.GraphSageTrainMetrics metrics() {
        return this.metrics;
    }

    @Override
    public Layer[] layers() {
        return (Layer[])this.layers.clone();
    }

    public final ImmutableModelTrainResult withMetrics(GraphSageModelTrainer.GraphSageTrainMetrics value) {
        if (this.metrics == value) {
            return this;
        }
        GraphSageModelTrainer.GraphSageTrainMetrics newValue = Objects.requireNonNull(value, "metrics");
        return new ImmutableModelTrainResult(this, newValue, this.layers);
    }

    public final ImmutableModelTrainResult withLayers(Layer ... elements) {
        Layer[] newValue = (Layer[])elements.clone();
        return new ImmutableModelTrainResult(this, this.metrics, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelTrainResult && this.equalTo((ImmutableModelTrainResult)another);
    }

    private boolean equalTo(ImmutableModelTrainResult another) {
        return this.metrics.equals(another.metrics) && Arrays.equals(this.layers, another.layers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + Arrays.hashCode(this.layers);
        return h;
    }

    public String toString() {
        return "ModelTrainResult{metrics=" + this.metrics + ", layers=" + Arrays.toString(this.layers) + "}";
    }

    public static GraphSageModelTrainer.ModelTrainResult of(GraphSageModelTrainer.GraphSageTrainMetrics metrics, Layer[] layers) {
        return new ImmutableModelTrainResult(metrics, layers);
    }

    public static GraphSageModelTrainer.ModelTrainResult copyOf(GraphSageModelTrainer.ModelTrainResult instance) {
        if (instance instanceof ImmutableModelTrainResult) {
            return (ImmutableModelTrainResult)instance;
        }
        return ImmutableModelTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphSageModelTrainer.ModelTrainResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_METRICS = 1L;
        private static final long INIT_BIT_LAYERS = 2L;
        private long initBits = 3L;
        private GraphSageModelTrainer.GraphSageTrainMetrics metrics;
        private Layer[] layers;

        private Builder() {
        }

        public final Builder from(GraphSageModelTrainer.ModelTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.metrics(instance.metrics());
            this.layers(instance.layers());
            return this;
        }

        public final Builder metrics(GraphSageModelTrainer.GraphSageTrainMetrics metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder layers(Layer ... layers) {
            this.layers = (Layer[])layers.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.metrics = null;
            this.layers = null;
            return this;
        }

        public GraphSageModelTrainer.ModelTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelTrainResult(null, this.metrics, this.layers);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metrics");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("layers");
            }
            return "Cannot build ModelTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

