/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.graphsage.FeatureFunction;
import org.neo4j.gds.ml.core.Variable;
import org.neo4j.gds.ml.core.functions.LazyConstant;
import org.neo4j.gds.ml.core.tensor.Matrix;

public class SingleLabelFeatureFunction
implements FeatureFunction {
    @Override
    public Variable<Matrix> apply(Graph graph, long[] nodeIds, HugeObjectArray<double[]> features) {
        int featureDimension = ((double[])features.get(0L)).length;
        int[] dimension = new int[]{nodeIds.length, featureDimension};
        return new LazyConstant(() -> this.batchedFeatureExtractor(nodeIds, features, featureDimension), dimension);
    }

    @NotNull
    private Matrix batchedFeatureExtractor(long[] nodeIds, HugeObjectArray<double[]> features, int featureDimension) {
        int batchLength = nodeIds.length;
        Matrix batchFeatures = new Matrix(batchLength, featureDimension);
        for (int batchIdx = 0; batchIdx < batchLength; ++batchIdx) {
            batchFeatures.setRow(batchIdx, (double[])features.get(nodeIds[batchIdx]));
        }
        return batchFeatures;
    }
}

