/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.graphsage.ActivationFunction;
import org.neo4j.gds.embeddings.graphsage.Aggregator;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.model.ModelConfig;

public final class GraphSageTrainConfigImpl
implements GraphSageTrainConfig {
    private List<String> featureProperties;
    private int embeddingDimension;
    private List<Integer> sampleSizes;
    private Aggregator.AggregatorType aggregator;
    private ActivationFunction activationFunction;
    private double tolerance;
    private double learningRate;
    private int epochs;
    private int maxIterations;
    private Optional<Double> maybeBatchSamplingRatio;
    private double penaltyL2;
    private int searchDepth;
    private int negativeSampleWeight;
    private Optional<Integer> projectedFeatureDimension;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private String modelName;
    private String modelUser;
    private int batchSize;
    private Optional<String> relationshipWeightProperty;
    private Optional<Long> randomSeed;

    public GraphSageTrainConfigImpl(@NotNull String modelUser, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.featureProperties = (List)CypherMapAccess.failOnNull((String)"featureProperties", (Object)((List)config.requireChecked("featureProperties", List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.embeddingDimension = config.getInt("embeddingDimension", GraphSageTrainConfig.super.embeddingDimension());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleSizes = (List)CypherMapAccess.failOnNull((String)"sampleSizes", GraphSageTrainConfig.convertToIntSamples((List)config.getChecked("sampleSizes", GraphSageTrainConfig.super.sampleSizes(), List.class)));
            this.sampleSizes.forEach(sampleSizes -> CypherMapAccess.validateIntegerRange((String)"sampleSizes", (int)sampleSizes, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.aggregator = (Aggregator.AggregatorType)((Object)CypherMapAccess.failOnNull((String)"aggregator", (Object)((Object)Aggregator.AggregatorType.parse(config.getChecked("aggregator", (Object)GraphSageTrainConfig.super.aggregator(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.activationFunction = (ActivationFunction)((Object)CypherMapAccess.failOnNull((String)"activationFunction", (Object)((Object)ActivationFunction.parse(config.getChecked("activationFunction", (Object)GraphSageTrainConfig.super.activationFunction(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.tolerance = config.getDouble("tolerance", GraphSageTrainConfig.super.tolerance());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.learningRate = config.getDouble("learningRate", GraphSageTrainConfig.super.learningRate());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.epochs = config.getInt("epochs", GraphSageTrainConfig.super.epochs());
            CypherMapAccess.validateIntegerRange((String)"epochs", (int)this.epochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", GraphSageTrainConfig.super.maxIterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maybeBatchSamplingRatio = (Optional)CypherMapAccess.failOnNull((String)"batchSamplingRatio", (Object)config.getOptional("batchSamplingRatio", Double.class));
            this.maybeBatchSamplingRatio.ifPresent(maybeBatchSamplingRatio -> CypherMapAccess.validateDoubleRange((String)"batchSamplingRatio", (double)maybeBatchSamplingRatio, (double)0.0, (double)1.0, (boolean)false, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.penaltyL2 = config.getDouble("penaltyL2", GraphSageTrainConfig.super.penaltyL2());
            CypherMapAccess.validateDoubleRange((String)"penaltyL2", (double)this.penaltyL2, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.searchDepth = config.getInt("searchDepth", GraphSageTrainConfig.super.searchDepth());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSampleWeight = config.getInt("negativeSampleWeight", GraphSageTrainConfig.super.negativeSampleWeight());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.projectedFeatureDimension = (Optional)CypherMapAccess.failOnNull((String)"projectedFeatureDimension", (Object)config.getOptional("projectedFeatureDimension", Integer.class));
            this.projectedFeatureDimension.ifPresent(projectedFeatureDimension -> CypherMapAccess.validateIntegerRange((String)"projectedFeatureDimension", (int)projectedFeatureDimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)GraphSageTrainConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)GraphSageTrainConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphSageTrainConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", GraphSageTrainConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", GraphSageTrainConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)GraphSageTrainConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapAccess.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelUser = (String)CypherMapAccess.failOnNull((String)"modelUser", (Object)modelUser);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.batchSize = config.getInt("batchSize", GraphSageTrainConfig.super.batchSize());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public List<String> featureProperties() {
        return this.featureProperties;
    }

    @Override
    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    @Override
    public List<Integer> sampleSizes() {
        return this.sampleSizes;
    }

    @Override
    public Aggregator.AggregatorType aggregator() {
        return this.aggregator;
    }

    @Override
    public ActivationFunction activationFunction() {
        return this.activationFunction;
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    @Override
    public double learningRate() {
        return this.learningRate;
    }

    @Override
    public int epochs() {
        return this.epochs;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public Optional<Double> maybeBatchSamplingRatio() {
        return this.maybeBatchSamplingRatio;
    }

    @Override
    public double penaltyL2() {
        return this.penaltyL2;
    }

    @Override
    public int searchDepth() {
        return this.searchDepth;
    }

    @Override
    public int negativeSampleWeight() {
        return this.negativeSampleWeight;
    }

    @Override
    public Optional<Integer> projectedFeatureDimension() {
        return this.projectedFeatureDimension;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNonEmptyGraph(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateFeatureProperties(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("featureProperties", "embeddingDimension", "sampleSizes", "aggregator", "activationFunction", "tolerance", "learningRate", "epochs", "maxIterations", "batchSamplingRatio", "penaltyL2", "searchDepth", "negativeSampleWeight", "projectedFeatureDimension", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "modelName", "batchSize", "relationshipWeightProperty", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("featureProperties", this.featureProperties());
        map.put("embeddingDimension", this.embeddingDimension());
        map.put("sampleSizes", this.sampleSizes());
        map.put("aggregator", Aggregator.AggregatorType.toString(this.aggregator()));
        map.put("activationFunction", ActivationFunction.toString(this.activationFunction()));
        map.put("tolerance", this.tolerance());
        map.put("learningRate", this.learningRate());
        map.put("epochs", this.epochs());
        map.put("maxIterations", this.maxIterations());
        this.maybeBatchSamplingRatio().ifPresent(batchSamplingRatio -> map.put("batchSamplingRatio", batchSamplingRatio));
        map.put("penaltyL2", this.penaltyL2());
        map.put("searchDepth", this.searchDepth());
        map.put("negativeSampleWeight", this.negativeSampleWeight());
        this.projectedFeatureDimension().ifPresent(projectedFeatureDimension -> map.put("projectedFeatureDimension", projectedFeatureDimension));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("modelName", this.modelName());
        map.put("batchSize", this.batchSize());
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String modelUser;

        public static Builder from(GraphSageTrainConfig baseConfig) {
            Builder builder = new Builder();
            builder.featureProperties(baseConfig.featureProperties());
            builder.embeddingDimension(baseConfig.embeddingDimension());
            builder.sampleSizes(baseConfig.sampleSizes());
            builder.aggregator((Object)baseConfig.aggregator());
            builder.activationFunction((Object)baseConfig.activationFunction());
            builder.tolerance(baseConfig.tolerance());
            builder.learningRate(baseConfig.learningRate());
            builder.epochs(baseConfig.epochs());
            builder.maxIterations(baseConfig.maxIterations());
            builder.maybeBatchSamplingRatio(baseConfig.maybeBatchSamplingRatio());
            builder.penaltyL2(baseConfig.penaltyL2());
            builder.searchDepth(baseConfig.searchDepth());
            builder.negativeSampleWeight(baseConfig.negativeSampleWeight());
            builder.projectedFeatureDimension(baseConfig.projectedFeatureDimension());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.modelName(baseConfig.modelName());
            builder.modelUser(baseConfig.modelUser());
            builder.batchSize(baseConfig.batchSize());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.randomSeed(baseConfig.randomSeed());
            return builder;
        }

        public Builder modelUser(String modelUser) {
            this.modelUser = modelUser;
            return this;
        }

        public Builder featureProperties(List<String> featureProperties) {
            this.config.put("featureProperties", featureProperties);
            return this;
        }

        public Builder embeddingDimension(int embeddingDimension) {
            this.config.put("embeddingDimension", embeddingDimension);
            return this;
        }

        public Builder sampleSizes(List<? extends Number> sampleSizes) {
            this.config.put("sampleSizes", sampleSizes);
            return this;
        }

        public Builder aggregator(Object aggregator) {
            this.config.put("aggregator", aggregator);
            return this;
        }

        public Builder activationFunction(Object activationFunction) {
            this.config.put("activationFunction", activationFunction);
            return this;
        }

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.config.put("learningRate", learningRate);
            return this;
        }

        public Builder epochs(int epochs) {
            this.config.put("epochs", epochs);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder maybeBatchSamplingRatio(Double maybeBatchSamplingRatio) {
            this.config.put("batchSamplingRatio", maybeBatchSamplingRatio);
            return this;
        }

        public Builder maybeBatchSamplingRatio(Optional<Double> maybeBatchSamplingRatio) {
            maybeBatchSamplingRatio.ifPresent(actualmaybeBatchSamplingRatio -> this.config.put("batchSamplingRatio", actualmaybeBatchSamplingRatio));
            return this;
        }

        public Builder penaltyL2(double penaltyL2) {
            this.config.put("penaltyL2", penaltyL2);
            return this;
        }

        public Builder searchDepth(int searchDepth) {
            this.config.put("searchDepth", searchDepth);
            return this;
        }

        public Builder negativeSampleWeight(int negativeSampleWeight) {
            this.config.put("negativeSampleWeight", negativeSampleWeight);
            return this;
        }

        public Builder projectedFeatureDimension(Integer projectedFeatureDimension) {
            this.config.put("projectedFeatureDimension", projectedFeatureDimension);
            return this;
        }

        public Builder projectedFeatureDimension(Optional<Integer> projectedFeatureDimension) {
            projectedFeatureDimension.ifPresent(actualprojectedFeatureDimension -> this.config.put("projectedFeatureDimension", actualprojectedFeatureDimension));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public GraphSageTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphSageTrainConfigImpl(this.modelUser, (CypherMapAccess)config);
        }
    }
}

