/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.Layer;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageModel;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;

@Generated(from="GraphSageModel", generator="Immutables")
public final class ImmutableGraphSageModel
implements GraphSageModel {
    private final Layer[] layers;
    private final GraphSageTrainConfig config;

    private ImmutableGraphSageModel(Layer[] layers, GraphSageTrainConfig config) {
        this.layers = (Layer[])layers.clone();
        this.config = Objects.requireNonNull(config, "config");
    }

    private ImmutableGraphSageModel(ImmutableGraphSageModel original, Layer[] layers, GraphSageTrainConfig config) {
        this.layers = layers;
        this.config = config;
    }

    @Override
    public Layer[] layers() {
        return (Layer[])this.layers.clone();
    }

    @Override
    public GraphSageTrainConfig config() {
        return this.config;
    }

    public final ImmutableGraphSageModel withLayers(Layer ... elements) {
        Layer[] newValue = (Layer[])elements.clone();
        return new ImmutableGraphSageModel(this, newValue, this.config);
    }

    public final ImmutableGraphSageModel withConfig(GraphSageTrainConfig value) {
        if (this.config == value) {
            return this;
        }
        GraphSageTrainConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableGraphSageModel(this, this.layers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageModel && this.equalTo((ImmutableGraphSageModel)another);
    }

    private boolean equalTo(ImmutableGraphSageModel another) {
        return Arrays.equals(this.layers, another.layers) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.layers);
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return "GraphSageModel{layers=" + Arrays.toString(this.layers) + ", config=" + this.config + "}";
    }

    public static GraphSageModel of(Layer[] layers, GraphSageTrainConfig config) {
        return new ImmutableGraphSageModel(layers, config);
    }

    public static GraphSageModel copyOf(GraphSageModel instance) {
        if (instance instanceof ImmutableGraphSageModel) {
            return (ImmutableGraphSageModel)instance;
        }
        return ImmutableGraphSageModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphSageModel", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_LAYERS = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private long initBits = 3L;
        private Layer[] layers;
        private GraphSageTrainConfig config;

        private Builder() {
        }

        public final Builder from(GraphSageModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.layers(instance.layers());
            this.config(instance.config());
            return this;
        }

        public final Builder layers(Layer ... layers) {
            this.layers = (Layer[])layers.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder config(GraphSageTrainConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.layers = null;
            this.config = null;
            return this;
        }

        public GraphSageModel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphSageModel(null, this.layers, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("layers");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build GraphSageModel, some of required attributes are not set " + attributes;
        }
    }
}

