/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSage;

@Generated(from="GraphSage.GraphSageResult", generator="Immutables")
public final class ImmutableGraphSageResult
implements GraphSage.GraphSageResult {
    private final HugeObjectArray<double[]> embeddings;

    private ImmutableGraphSageResult(HugeObjectArray<double[]> embeddings) {
        this.embeddings = Objects.requireNonNull(embeddings, "embeddings");
    }

    private ImmutableGraphSageResult(ImmutableGraphSageResult original, HugeObjectArray<double[]> embeddings) {
        this.embeddings = embeddings;
    }

    @Override
    public HugeObjectArray<double[]> embeddings() {
        return this.embeddings;
    }

    public final ImmutableGraphSageResult withEmbeddings(HugeObjectArray<double[]> value) {
        if (this.embeddings == value) {
            return this;
        }
        HugeObjectArray<double[]> newValue = Objects.requireNonNull(value, "embeddings");
        return new ImmutableGraphSageResult(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageResult && this.equalTo((ImmutableGraphSageResult)another);
    }

    private boolean equalTo(ImmutableGraphSageResult another) {
        return this.embeddings.equals(another.embeddings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.embeddings.hashCode();
        return h;
    }

    public String toString() {
        return "GraphSageResult{embeddings=" + this.embeddings + "}";
    }

    public static GraphSage.GraphSageResult of(HugeObjectArray<double[]> embeddings) {
        return new ImmutableGraphSageResult(embeddings);
    }

    public static GraphSage.GraphSageResult copyOf(GraphSage.GraphSageResult instance) {
        if (instance instanceof ImmutableGraphSageResult) {
            return (ImmutableGraphSageResult)instance;
        }
        return ImmutableGraphSageResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphSage.GraphSageResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMBEDDINGS = 1L;
        private long initBits = 1L;
        private HugeObjectArray<double[]> embeddings;

        private Builder() {
        }

        public final Builder from(GraphSage.GraphSageResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.embeddings(instance.embeddings());
            return this;
        }

        public final Builder embeddings(HugeObjectArray<double[]> embeddings) {
            this.embeddings = Objects.requireNonNull(embeddings, "embeddings");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.embeddings = null;
            return this;
        }

        public GraphSage.GraphSageResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphSageResult(null, this.embeddings);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("embeddings");
            }
            return "Cannot build GraphSageResult, some of required attributes are not set " + attributes;
        }
    }
}

