/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.BatchSizeConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.graphsage.ActivationFunction;
import org.neo4j.gds.embeddings.graphsage.Aggregator;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.model.ModelConfig;

@Generated(from="GraphSageTrainConfig", generator="Immutables")
public final class ImmutableGraphSageTrainConfig
implements GraphSageTrainConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String modelName;
    private final String modelUser;
    private final int batchSize;
    private final String relationshipWeightProperty;
    private final boolean hasRelationshipWeightProperty;
    private final Long randomSeed;
    private final List<String> featureProperties;
    private final int embeddingDimension;
    private final List<Integer> sampleSizes;
    private final Aggregator.AggregatorType aggregator;
    private final ActivationFunction activationFunction;
    private final double tolerance;
    private final double learningRate;
    private final int epochs;
    private final int maxIterations;
    private final Double maybeBatchSamplingRatio;
    private final int searchDepth;
    private final int negativeSampleWeight;
    private final Integer projectedFeatureDimension;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 66L;

    private ImmutableGraphSageTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String modelUser, int batchSize, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, Iterable<String> featureProperties, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Optional<Double> maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.modelUser = Objects.requireNonNull(modelUser, "modelUser");
        this.initShim.batchSize(batchSize);
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.randomSeed = randomSeed.orElse(null);
        this.featureProperties = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(featureProperties, true, false));
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(sampleSizes, true, false)));
        this.initShim.aggregator(Objects.requireNonNull(aggregator, "aggregator"));
        this.initShim.activationFunction(Objects.requireNonNull(activationFunction, "activationFunction"));
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.maybeBatchSamplingRatio = maybeBatchSamplingRatio.orElse(null);
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension.orElse(null);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.batchSize = this.initShim.batchSize();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String modelUser, int batchSize, String relationshipWeightProperty, Long randomSeed, Iterable<String> featureProperties, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Double maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.modelUser = Objects.requireNonNull(modelUser, "modelUser");
        this.initShim.batchSize(batchSize);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.featureProperties = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(featureProperties, true, false));
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(sampleSizes, true, false)));
        this.initShim.aggregator(Objects.requireNonNull(aggregator, "aggregator"));
        this.initShim.activationFunction(Objects.requireNonNull(activationFunction, "activationFunction"));
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.maybeBatchSamplingRatio = maybeBatchSamplingRatio;
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.batchSize = this.initShim.batchSize();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.modelName = builder.modelName;
        this.modelUser = builder.modelUser;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.randomSeed = builder.randomSeed;
        this.featureProperties = builder.featureProperties == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.featureProperties);
        this.maybeBatchSamplingRatio = builder.maybeBatchSamplingRatio;
        this.projectedFeatureDimension = builder.projectedFeatureDimension;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.embeddingDimensionIsSet()) {
            this.initShim.embeddingDimension(builder.embeddingDimension);
        }
        if (builder.sampleSizesIsSet()) {
            this.initShim.sampleSizes(builder.sampleSizes == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.sampleSizes));
        }
        if (builder.aggregator != null) {
            this.initShim.aggregator(builder.aggregator);
        }
        if (builder.activationFunction != null) {
            this.initShim.activationFunction(builder.activationFunction);
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.learningRateIsSet()) {
            this.initShim.learningRate(builder.learningRate);
        }
        if (builder.epochsIsSet()) {
            this.initShim.epochs(builder.epochs);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.searchDepthIsSet()) {
            this.initShim.searchDepth(builder.searchDepth);
        }
        if (builder.negativeSampleWeightIsSet()) {
            this.initShim.negativeSampleWeight(builder.negativeSampleWeight);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.batchSize = this.initShim.batchSize();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String modelUser, int batchSize, String relationshipWeightProperty, Long randomSeed, List<String> featureProperties, int embeddingDimension, List<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Double maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.modelName = modelName;
        this.modelUser = modelUser;
        this.initShim.batchSize(batchSize);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.featureProperties = featureProperties;
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(sampleSizes);
        this.initShim.aggregator(aggregator);
        this.initShim.activationFunction(activationFunction);
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.maybeBatchSamplingRatio = maybeBatchSamplingRatio;
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.batchSize = this.initShim.batchSize();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphSageTrainConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return GraphSageTrainConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return GraphSageTrainConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphSageTrainConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return GraphSageTrainConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return GraphSageTrainConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return GraphSageTrainConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return GraphSageTrainConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return GraphSageTrainConfig.super.nodeLabels();
    }

    private int batchSizeInitialize() {
        return GraphSageTrainConfig.super.batchSize();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return GraphSageTrainConfig.super.hasRelationshipWeightProperty();
    }

    private int embeddingDimensionInitialize() {
        return GraphSageTrainConfig.super.embeddingDimension();
    }

    private List<Integer> sampleSizesInitialize() {
        return GraphSageTrainConfig.super.sampleSizes();
    }

    private Aggregator.AggregatorType aggregatorInitialize() {
        return GraphSageTrainConfig.super.aggregator();
    }

    private ActivationFunction activationFunctionInitialize() {
        return GraphSageTrainConfig.super.activationFunction();
    }

    private double toleranceInitialize() {
        return GraphSageTrainConfig.super.tolerance();
    }

    private double learningRateInitialize() {
        return GraphSageTrainConfig.super.learningRate();
    }

    private int epochsInitialize() {
        return GraphSageTrainConfig.super.epochs();
    }

    private int maxIterationsInitialize() {
        return GraphSageTrainConfig.super.maxIterations();
    }

    private int searchDepthInitialize() {
        return GraphSageTrainConfig.super.searchDepth();
    }

    private int negativeSampleWeightInitialize() {
        return GraphSageTrainConfig.super.negativeSampleWeight();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public List<String> featureProperties() {
        return this.featureProperties;
    }

    @Override
    public int embeddingDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeddingDimension() : this.embeddingDimension;
    }

    @Override
    public List<Integer> sampleSizes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sampleSizes() : this.sampleSizes;
    }

    @Override
    public Aggregator.AggregatorType aggregator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregator() : this.aggregator;
    }

    @Override
    public ActivationFunction activationFunction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.activationFunction() : this.activationFunction;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public double learningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.learningRate() : this.learningRate;
    }

    @Override
    public int epochs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.epochs() : this.epochs;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public Optional<Double> maybeBatchSamplingRatio() {
        return Optional.ofNullable(this.maybeBatchSamplingRatio);
    }

    @Override
    public int searchDepth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.searchDepth() : this.searchDepth;
    }

    @Override
    public int negativeSampleWeight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSampleWeight() : this.negativeSampleWeight;
    }

    @Override
    public Optional<Integer> projectedFeatureDimension() {
        return Optional.ofNullable(this.projectedFeatureDimension);
    }

    public final ImmutableGraphSageTrainConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withModelUser(String value) {
        String newValue = Objects.requireNonNull(value, "modelUser");
        if (this.modelUser.equals(newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, newValue, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, value, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, newValue, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, value, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, newValue, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, value, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withFeatureProperties(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, newValue, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withFeatureProperties(Iterable<String> elements) {
        if (this.featureProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, newValue, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, value, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSampleSizes(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, newValue, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSampleSizes(Iterable<Integer> elements) {
        if (this.sampleSizes == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, newValue, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withAggregator(Aggregator.AggregatorType value) {
        if (this.aggregator == value) {
            return this;
        }
        Aggregator.AggregatorType newValue = Objects.requireNonNull(value, "aggregator");
        if (this.aggregator.equals((Object)newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, newValue, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withActivationFunction(ActivationFunction value) {
        if (this.activationFunction == value) {
            return this;
        }
        ActivationFunction newValue = Objects.requireNonNull(value, "activationFunction");
        if (this.activationFunction.equals((Object)newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, newValue, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, value, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withLearningRate(double value) {
        if (Double.doubleToLongBits(this.learningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, value, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withEpochs(int value) {
        if (this.epochs == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, value, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, value, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMaybeBatchSamplingRatio(Double value) {
        Double newValue = value;
        if (Objects.equals(this.maybeBatchSamplingRatio, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, newValue, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMaybeBatchSamplingRatio(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maybeBatchSamplingRatio, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, value, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSearchDepth(int value) {
        if (this.searchDepth == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, value, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNegativeSampleWeight(int value) {
        if (this.negativeSampleWeight == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, value, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withProjectedFeatureDimension(Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.projectedFeatureDimension, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, newValue));
    }

    public final ImmutableGraphSageTrainConfig withProjectedFeatureDimension(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.projectedFeatureDimension, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.modelName, this.modelUser, this.batchSize, this.relationshipWeightProperty, this.randomSeed, this.featureProperties, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.maybeBatchSamplingRatio, this.searchDepth, this.negativeSampleWeight, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageTrainConfig && this.equalTo((ImmutableGraphSageTrainConfig)another);
    }

    private boolean equalTo(ImmutableGraphSageTrainConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.modelName.equals(another.modelName) && this.modelUser.equals(another.modelUser) && this.batchSize == another.batchSize && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.randomSeed, another.randomSeed) && this.featureProperties.equals(another.featureProperties) && this.embeddingDimension == another.embeddingDimension && this.sampleSizes.equals(another.sampleSizes) && this.aggregator.equals((Object)another.aggregator) && this.activationFunction.equals((Object)another.activationFunction) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && Double.doubleToLongBits(this.learningRate) == Double.doubleToLongBits(another.learningRate) && this.epochs == another.epochs && this.maxIterations == another.maxIterations && Objects.equals(this.maybeBatchSamplingRatio, another.maybeBatchSamplingRatio) && this.searchDepth == another.searchDepth && this.negativeSampleWeight == another.negativeSampleWeight && Objects.equals(this.projectedFeatureDimension, another.projectedFeatureDimension);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.modelUser.hashCode();
        h += (h << 5) + this.batchSize;
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.featureProperties.hashCode();
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + this.sampleSizes.hashCode();
        h += (h << 5) + this.aggregator.hashCode();
        h += (h << 5) + this.activationFunction.hashCode();
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + Double.hashCode(this.learningRate);
        h += (h << 5) + this.epochs;
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Objects.hashCode(this.maybeBatchSamplingRatio);
        h += (h << 5) + this.searchDepth;
        h += (h << 5) + this.negativeSampleWeight;
        h += (h << 5) + Objects.hashCode(this.projectedFeatureDimension);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphSageTrainConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("modelUser=").append(this.modelUser);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("featureProperties=").append(this.featureProperties);
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        builder.append(", ");
        builder.append("sampleSizes=").append(this.sampleSizes);
        builder.append(", ");
        builder.append("aggregator=").append((Object)this.aggregator);
        builder.append(", ");
        builder.append("activationFunction=").append((Object)this.activationFunction);
        builder.append(", ");
        builder.append("tolerance=").append(this.tolerance);
        builder.append(", ");
        builder.append("learningRate=").append(this.learningRate);
        builder.append(", ");
        builder.append("epochs=").append(this.epochs);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        if (this.maybeBatchSamplingRatio != null) {
            builder.append(", ");
            builder.append("maybeBatchSamplingRatio=").append(this.maybeBatchSamplingRatio);
        }
        builder.append(", ");
        builder.append("searchDepth=").append(this.searchDepth);
        builder.append(", ");
        builder.append("negativeSampleWeight=").append(this.negativeSampleWeight);
        if (this.projectedFeatureDimension != null) {
            builder.append(", ");
            builder.append("projectedFeatureDimension=").append(this.projectedFeatureDimension);
        }
        return builder.append("}").toString();
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String modelUser, int batchSize, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, List<String> featureProperties, int embeddingDimension, List<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Optional<Double> maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, modelUser, batchSize, relationshipWeightProperty, randomSeed, featureProperties, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, maybeBatchSamplingRatio, searchDepth, negativeSampleWeight, projectedFeatureDimension);
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String modelUser, int batchSize, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, Iterable<String> featureProperties, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Optional<Double> maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, modelUser, batchSize, relationshipWeightProperty, randomSeed, featureProperties, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, maybeBatchSamplingRatio, searchDepth, negativeSampleWeight, projectedFeatureDimension));
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String modelUser, int batchSize, String relationshipWeightProperty, Long randomSeed, Iterable<String> featureProperties, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, Double maybeBatchSamplingRatio, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, modelUser, batchSize, relationshipWeightProperty, randomSeed, featureProperties, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, maybeBatchSamplingRatio, searchDepth, negativeSampleWeight, projectedFeatureDimension));
    }

    private static ImmutableGraphSageTrainConfig validate(ImmutableGraphSageTrainConfig instance) {
        instance.validate();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static GraphSageTrainConfig copyOf(GraphSageTrainConfig instance) {
        if (instance instanceof ImmutableGraphSageTrainConfig) {
            return (ImmutableGraphSageTrainConfig)instance;
        }
        return ImmutableGraphSageTrainConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableGraphSageTrainConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphSageTrainConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long INIT_BIT_MODEL_USER = 2L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_BATCH_SIZE = 64L;
        private static final long OPT_BIT_EMBEDDING_DIMENSION = 128L;
        private static final long OPT_BIT_SAMPLE_SIZES = 256L;
        private static final long OPT_BIT_TOLERANCE = 512L;
        private static final long OPT_BIT_LEARNING_RATE = 1024L;
        private static final long OPT_BIT_EPOCHS = 2048L;
        private static final long OPT_BIT_MAX_ITERATIONS = 4096L;
        private static final long OPT_BIT_SEARCH_DEPTH = 8192L;
        private static final long OPT_BIT_NEGATIVE_SAMPLE_WEIGHT = 16384L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String modelName;
        private String modelUser;
        private int batchSize;
        private String relationshipWeightProperty;
        private Long randomSeed;
        private List<String> featureProperties = null;
        private int embeddingDimension;
        private List<Integer> sampleSizes = null;
        private Aggregator.AggregatorType aggregator;
        private ActivationFunction activationFunction;
        private double tolerance;
        private double learningRate;
        private int epochs;
        private int maxIterations;
        private Double maybeBatchSamplingRatio;
        private int searchDepth;
        private int negativeSampleWeight;
        private Integer projectedFeatureDimension;

        private Builder() {
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphSageTrainConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FeaturePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchSizeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional relationshipWeightPropertyOptional;
            Optional randomSeedOptional;
            ModelConfig instance;
            long bits = 0L;
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelUser(instance.modelUser());
                this.modelName(instance.modelName());
            }
            if (object instanceof GraphSageTrainConfig) {
                instance = (GraphSageTrainConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.negativeSampleWeight(instance.negativeSampleWeight());
                Optional<Double> maybeBatchSamplingRatioOptional = instance.maybeBatchSamplingRatio();
                if (maybeBatchSamplingRatioOptional.isPresent()) {
                    this.maybeBatchSamplingRatio(maybeBatchSamplingRatioOptional);
                }
                this.searchDepth(instance.searchDepth());
                Optional<Integer> projectedFeatureDimensionOptional = instance.projectedFeatureDimension();
                if (projectedFeatureDimensionOptional.isPresent()) {
                    this.projectedFeatureDimension(projectedFeatureDimensionOptional);
                }
                this.aggregator(instance.aggregator());
                this.activationFunction(instance.activationFunction());
                this.learningRate(instance.learningRate());
                if ((bits & 4L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllFeatureProperties(instance.featureProperties());
                    bits |= 8L;
                }
                this.addAllSampleSizes(instance.sampleSizes());
                this.epochs(instance.epochs());
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof FeaturePropertiesConfig) {
                instance = (FeaturePropertiesConfig)object;
                if ((bits & 8L) == 0L) {
                    this.addAllFeatureProperties(instance.featureProperties());
                    bits |= 8L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BatchSizeConfig) {
                instance = (BatchSizeConfig)object;
                this.batchSize(instance.batchSize());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                if ((bits & 4L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 4L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modelUser(String modelUser) {
            this.modelUser = Objects.requireNonNull(modelUser, "modelUser");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder addFeatureProperty(String element) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            return this;
        }

        public final Builder addFeatureProperties(String ... elements) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            return this;
        }

        public final Builder featureProperties(Iterable<String> elements) {
            this.featureProperties = new ArrayList<String>();
            return this.addAllFeatureProperties(elements);
        }

        public final Builder addAllFeatureProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "featureProperties element");
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addSampleSize(int element) {
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            this.sampleSizes.add(element);
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder addSampleSizes(int ... elements) {
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.sampleSizes.add(element);
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder sampleSizes(Iterable<Integer> elements) {
            this.sampleSizes = new ArrayList<Integer>();
            return this.addAllSampleSizes(elements);
        }

        public final Builder addAllSampleSizes(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "sampleSizes element");
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.sampleSizes.add(Objects.requireNonNull(Integer.valueOf(element), "sampleSizes element"));
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder aggregator(Aggregator.AggregatorType aggregator) {
            this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
            return this;
        }

        public final Builder activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = Objects.requireNonNull(activationFunction, "activationFunction");
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder epochs(int epochs) {
            this.epochs = epochs;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder maybeBatchSamplingRatio(Double maybeBatchSamplingRatio) {
            this.maybeBatchSamplingRatio = maybeBatchSamplingRatio;
            return this;
        }

        public final Builder maybeBatchSamplingRatio(Optional<Double> maybeBatchSamplingRatio) {
            this.maybeBatchSamplingRatio = maybeBatchSamplingRatio.orElse(null);
            return this;
        }

        public final Builder searchDepth(int searchDepth) {
            this.searchDepth = searchDepth;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder negativeSampleWeight(int negativeSampleWeight) {
            this.negativeSampleWeight = negativeSampleWeight;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder projectedFeatureDimension(Integer projectedFeatureDimension) {
            this.projectedFeatureDimension = projectedFeatureDimension;
            return this;
        }

        public final Builder projectedFeatureDimension(Optional<Integer> projectedFeatureDimension) {
            this.projectedFeatureDimension = projectedFeatureDimension.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.modelName = null;
            this.modelUser = null;
            this.batchSize = 0;
            this.relationshipWeightProperty = null;
            this.randomSeed = null;
            if (this.featureProperties != null) {
                this.featureProperties.clear();
            }
            this.embeddingDimension = 0;
            if (this.sampleSizes != null) {
                this.sampleSizes.clear();
            }
            this.aggregator = null;
            this.activationFunction = null;
            this.tolerance = 0.0;
            this.learningRate = 0.0;
            this.epochs = 0;
            this.maxIterations = 0;
            this.maybeBatchSamplingRatio = null;
            this.searchDepth = 0;
            this.negativeSampleWeight = 0;
            this.projectedFeatureDimension = null;
            return this;
        }

        public GraphSageTrainConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean embeddingDimensionIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean sampleSizesIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean learningRateIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean epochsIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean searchDepthIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean negativeSampleWeightIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modelUser");
            }
            return "Cannot build GraphSageTrainConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphSageTrainConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte embeddingDimensionBuildStage = 0;
        private int embeddingDimension;
        private byte sampleSizesBuildStage = 0;
        private List<Integer> sampleSizes;
        private byte aggregatorBuildStage = 0;
        private Aggregator.AggregatorType aggregator;
        private byte activationFunctionBuildStage = 0;
        private ActivationFunction activationFunction;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte learningRateBuildStage = 0;
        private double learningRate;
        private byte epochsBuildStage = 0;
        private int epochs;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte searchDepthBuildStage = 0;
        private int searchDepth;
        private byte negativeSampleWeightBuildStage = 0;
        private int negativeSampleWeight;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphSageTrainConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableGraphSageTrainConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphSageTrainConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableGraphSageTrainConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableGraphSageTrainConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableGraphSageTrainConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        int embeddingDimension() {
            if (this.embeddingDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embeddingDimensionBuildStage == 0) {
                this.embeddingDimensionBuildStage = (byte)-1;
                this.embeddingDimension = ImmutableGraphSageTrainConfig.this.embeddingDimensionInitialize();
                this.embeddingDimensionBuildStage = 1;
            }
            return this.embeddingDimension;
        }

        void embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.embeddingDimensionBuildStage = 1;
        }

        List<Integer> sampleSizes() {
            if (this.sampleSizesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sampleSizesBuildStage == 0) {
                this.sampleSizesBuildStage = (byte)-1;
                this.sampleSizes = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.sampleSizesInitialize(), true, false));
                this.sampleSizesBuildStage = 1;
            }
            return this.sampleSizes;
        }

        void sampleSizes(List<Integer> sampleSizes) {
            this.sampleSizes = sampleSizes;
            this.sampleSizesBuildStage = 1;
        }

        Aggregator.AggregatorType aggregator() {
            if (this.aggregatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregatorBuildStage == 0) {
                this.aggregatorBuildStage = (byte)-1;
                this.aggregator = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.aggregatorInitialize(), "aggregator");
                this.aggregatorBuildStage = 1;
            }
            return this.aggregator;
        }

        void aggregator(Aggregator.AggregatorType aggregator) {
            this.aggregator = aggregator;
            this.aggregatorBuildStage = 1;
        }

        ActivationFunction activationFunction() {
            if (this.activationFunctionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.activationFunctionBuildStage == 0) {
                this.activationFunctionBuildStage = (byte)-1;
                this.activationFunction = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.activationFunctionInitialize(), "activationFunction");
                this.activationFunctionBuildStage = 1;
            }
            return this.activationFunction;
        }

        void activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = activationFunction;
            this.activationFunctionBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutableGraphSageTrainConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        double learningRate() {
            if (this.learningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.learningRateBuildStage == 0) {
                this.learningRateBuildStage = (byte)-1;
                this.learningRate = ImmutableGraphSageTrainConfig.this.learningRateInitialize();
                this.learningRateBuildStage = 1;
            }
            return this.learningRate;
        }

        void learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.learningRateBuildStage = 1;
        }

        int epochs() {
            if (this.epochsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.epochsBuildStage == 0) {
                this.epochsBuildStage = (byte)-1;
                this.epochs = ImmutableGraphSageTrainConfig.this.epochsInitialize();
                this.epochsBuildStage = 1;
            }
            return this.epochs;
        }

        void epochs(int epochs) {
            this.epochs = epochs;
            this.epochsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableGraphSageTrainConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int searchDepth() {
            if (this.searchDepthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.searchDepthBuildStage == 0) {
                this.searchDepthBuildStage = (byte)-1;
                this.searchDepth = ImmutableGraphSageTrainConfig.this.searchDepthInitialize();
                this.searchDepthBuildStage = 1;
            }
            return this.searchDepth;
        }

        void searchDepth(int searchDepth) {
            this.searchDepth = searchDepth;
            this.searchDepthBuildStage = 1;
        }

        int negativeSampleWeight() {
            if (this.negativeSampleWeightBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSampleWeightBuildStage == 0) {
                this.negativeSampleWeightBuildStage = (byte)-1;
                this.negativeSampleWeight = ImmutableGraphSageTrainConfig.this.negativeSampleWeightInitialize();
                this.negativeSampleWeightBuildStage = 1;
            }
            return this.negativeSampleWeight;
        }

        void negativeSampleWeight(int negativeSampleWeight) {
            this.negativeSampleWeight = negativeSampleWeight;
            this.negativeSampleWeightBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.embeddingDimensionBuildStage == -1) {
                attributes.add("embeddingDimension");
            }
            if (this.sampleSizesBuildStage == -1) {
                attributes.add("sampleSizes");
            }
            if (this.aggregatorBuildStage == -1) {
                attributes.add("aggregator");
            }
            if (this.activationFunctionBuildStage == -1) {
                attributes.add("activationFunction");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.learningRateBuildStage == -1) {
                attributes.add("learningRate");
            }
            if (this.epochsBuildStage == -1) {
                attributes.add("epochs");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.searchDepthBuildStage == -1) {
                attributes.add("searchDepth");
            }
            if (this.negativeSampleWeightBuildStage == -1) {
                attributes.add("negativeSampleWeight");
            }
            return "Cannot build GraphSageTrainConfig, attribute initializers form cycle " + attributes;
        }
    }
}

