/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.embeddings.graphsage.GraphSageHelper;
import org.neo4j.gds.embeddings.graphsage.GraphSageModelTrainer;
import org.neo4j.gds.embeddings.graphsage.ModelData;
import org.neo4j.gds.embeddings.graphsage.SingleLabelFeatureFunction;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrain;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.model.ModelConfig;

public class SingleLabelGraphSageTrain
extends GraphSageTrain {
    private final Graph graph;
    private final GraphSageTrainConfig config;
    private final ExecutorService executor;

    public SingleLabelGraphSageTrain(Graph graph, GraphSageTrainConfig config, ExecutorService executor, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.config = config;
        this.executor = executor;
    }

    public Model<ModelData, GraphSageTrainConfig, GraphSageModelTrainer.GraphSageTrainMetrics> compute() {
        this.progressTracker.beginSubTask("GraphSageTrain");
        GraphSageModelTrainer graphSageModel = new GraphSageModelTrainer(this.config, this.executor, this.progressTracker);
        GraphSageModelTrainer.ModelTrainResult trainResult = graphSageModel.train(this.graph, GraphSageHelper.initializeSingleLabelFeatures(this.graph, this.config));
        this.progressTracker.endSubTask("GraphSageTrain");
        return Model.of((String)"graphSage", (GraphSchema)this.graph.schema(), (Object)ModelData.of(trainResult.layers(), new SingleLabelFeatureFunction()), (ModelConfig)this.config, (ToMapConvertible)trainResult.metrics());
    }

    public void release() {
    }
}

