/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.List;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.embeddings.hashgnn.HashGNNConfig;

class DensifyTask
implements Runnable {
    static final int SPARSITY = 3;
    static final double ENTRY_PROBABILITY = 0.16666666666666666;
    private final Partition partition;
    private final HashGNNConfig config;
    private final HugeObjectArray<double[]> denseFeatures;
    private final HugeObjectArray<HugeAtomicBitSet> binaryFeatures;
    private final float[][] projectionMatrix;
    private final ProgressTracker progressTracker;

    DensifyTask(Partition partition, HashGNNConfig config, HugeObjectArray<double[]> denseFeatures, HugeObjectArray<HugeAtomicBitSet> binaryFeatures, float[][] projectionMatrix, ProgressTracker progressTracker) {
        this.partition = partition;
        this.config = config;
        this.denseFeatures = denseFeatures;
        this.binaryFeatures = binaryFeatures;
        this.projectionMatrix = projectionMatrix;
        this.progressTracker = progressTracker;
    }

    static HugeObjectArray<double[]> compute(Graph graph, List<Partition> partition, HashGNNConfig config, SplittableRandom rng, HugeObjectArray<HugeAtomicBitSet> binaryFeatures, ProgressTracker progressTracker, TerminationFlag terminationFlag) {
        progressTracker.beginSubTask("Densify output embeddings");
        HugeObjectArray denseFeatures = HugeObjectArray.newArray(double[].class, (long)graph.nodeCount());
        float[][] projectionMatrix = DensifyTask.projectionMatrix(rng, config.outputDimension().orElseThrow(), (int)((HugeAtomicBitSet)binaryFeatures.get(0L)).size());
        List tasks = partition.stream().map(p -> new DensifyTask((Partition)p, config, (HugeObjectArray<double[]>)denseFeatures, binaryFeatures, projectionMatrix, progressTracker)).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(config.concurrency()).tasks(tasks).terminationFlag(terminationFlag).run();
        progressTracker.endSubTask("Densify output embeddings");
        return denseFeatures;
    }

    private static float[][] projectionMatrix(SplittableRandom rng, int denseDimension, int binaryDimension) {
        float entryValue = (float)Math.sqrt(3.0) / (float)Math.sqrt(denseDimension);
        float[][] matrix = new float[binaryDimension][denseDimension];
        for (int i = 0; i < binaryDimension; ++i) {
            matrix[i] = new float[denseDimension];
            for (int d = 0; d < denseDimension; ++d) {
                matrix[i][d] = DensifyTask.computeRandomEntry(rng, entryValue);
            }
        }
        return matrix;
    }

    private static float computeRandomEntry(SplittableRandom random, float entryValue) {
        double randomValue = random.nextDouble();
        if (randomValue < 0.16666666666666666) {
            return entryValue;
        }
        if (randomValue < 0.3333333333333333) {
            return -entryValue;
        }
        return 0.0f;
    }

    @Override
    public void run() {
        int denseLength = this.projectionMatrix[0].length;
        this.partition.consume(nodeId -> {
            HugeAtomicBitSet binaryVector = (HugeAtomicBitSet)this.binaryFeatures.get(nodeId);
            double[] denseVector = new double[this.config.outputDimension().orElseThrow().intValue()];
            binaryVector.forEachSetBit(bit -> {
                float[] row = this.projectionMatrix[(int)bit];
                for (int i = 0; i < denseLength; ++i) {
                    int n = i;
                    denseVector[n] = denseVector[n] + (double)row[i];
                }
            });
            this.denseFeatures.set(nodeId, (Object)denseVector);
        });
        this.progressTracker.logProgress(this.partition.nodeCount());
    }
}

