/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.utils.StringFormatting;

@Configuration
public interface GenerateFeaturesConfig {
    @Configuration.IntegerRange(min=1)
    public int dimension();

    @Configuration.IntegerRange(min=1)
    public int densityLevel();

    @Configuration.ToMap
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, Object> toMap() {
        return Map.of();
    }

    @Configuration.CollectKeys
    @Value.Auxiliary
    @Value.Default
    @Value.Parameter(value=false)
    default public Collection<String> configKeys() {
        return List.of();
    }

    @Value.Check
    default public void validate() {
        if (this.densityLevel() > this.dimension()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Generate features requires `densityLevel` to be at most `dimension` but was %d > %d.", (Object[])new Object[]{this.densityLevel(), this.dimension()}));
        }
    }
}

