/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.hashgnn.GenerateFeaturesConfig;

public final class GenerateFeaturesConfigImpl
implements GenerateFeaturesConfig {
    private int dimension;
    private int densityLevel;

    public GenerateFeaturesConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.dimension = config.requireInt("dimension");
            CypherMapAccess.validateIntegerRange((String)"dimension", (int)this.dimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.densityLevel = config.requireInt("densityLevel");
            CypherMapAccess.validateIntegerRange((String)"densityLevel", (int)this.densityLevel, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int densityLevel() {
        return this.densityLevel;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("dimension", this.dimension());
        map.put("densityLevel", this.densityLevel());
        return map;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("dimension", "densityLevel");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(GenerateFeaturesConfig baseConfig) {
            Builder builder = new Builder();
            builder.dimension(baseConfig.dimension());
            builder.densityLevel(baseConfig.densityLevel());
            return builder;
        }

        public Builder dimension(int dimension) {
            this.config.put("dimension", dimension);
            return this;
        }

        public Builder densityLevel(int densityLevel) {
            this.config.put("densityLevel", densityLevel);
            return this;
        }

        public GenerateFeaturesConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GenerateFeaturesConfigImpl((CypherMapAccess)config);
        }
    }
}

