/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.embeddings.hashgnn.GenerateFeaturesConfig;
import org.neo4j.gds.embeddings.hashgnn.HashGNNConfig;

class GenerateFeaturesTask
implements Runnable {
    private final Partition partition;
    private final HugeObjectArray<HugeAtomicBitSet> output;
    private final Graph graph;
    private final Random rng;
    private final GenerateFeaturesConfig generateFeaturesConfig;
    private final ProgressTracker progressTracker;
    private final long randomSeed;
    private long totalFeatureCount = 0L;

    GenerateFeaturesTask(Partition partition, Graph graph, long randomSeed, GenerateFeaturesConfig config, HugeObjectArray<HugeAtomicBitSet> output, ProgressTracker progressTracker) {
        this.partition = partition;
        this.graph = graph;
        this.rng = new Random();
        this.randomSeed = randomSeed;
        this.generateFeaturesConfig = config;
        this.output = output;
        this.progressTracker = progressTracker;
    }

    static HugeObjectArray<HugeAtomicBitSet> compute(Graph graph, List<Partition> partition, HashGNNConfig config, long randomSeed, ProgressTracker progressTracker, TerminationFlag terminationFlag, MutableLong totalFeatureCountOutput) {
        progressTracker.beginSubTask("Generate base node property features");
        HugeObjectArray output = HugeObjectArray.newArray(HugeAtomicBitSet.class, (long)graph.nodeCount());
        List tasks = partition.stream().map(p -> new GenerateFeaturesTask((Partition)p, graph, randomSeed, config.generateFeatures().orElseThrow(), (HugeObjectArray<HugeAtomicBitSet>)output, progressTracker)).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(config.concurrency()).tasks(tasks).terminationFlag(terminationFlag).run();
        totalFeatureCountOutput.add(tasks.stream().mapToLong(GenerateFeaturesTask::totalFeatureCount).sum());
        progressTracker.endSubTask("Generate base node property features");
        return output;
    }

    @Override
    public void run() {
        int dimension = this.generateFeaturesConfig.dimension();
        int densityLevel = this.generateFeaturesConfig.densityLevel();
        this.partition.consume(nodeId -> {
            HugeAtomicBitSet generatedFeatures = HugeAtomicBitSet.create((long)dimension);
            this.rng.setSeed(this.randomSeed ^ this.graph.toOriginalNodeId(nodeId));
            IntStream randomInts = this.rng.ints(densityLevel, 0, dimension);
            randomInts.forEach(arg_0 -> ((HugeAtomicBitSet)generatedFeatures).set(arg_0));
            this.totalFeatureCount += generatedFeatures.cardinality();
            this.output.set(nodeId, (Object)generatedFeatures);
        });
        this.progressTracker.logProgress(this.partition.nodeCount());
    }

    public long totalFeatureCount() {
        return this.totalFeatureCount;
    }
}

