/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import java.util.SplittableRandom;
import org.apache.commons.math3.primes.Primes;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.embeddings.hashgnn.HashGNN;
import org.neo4j.gds.embeddings.hashgnn.ImmutableHashTriple;

public class HashGNNCompanion {
    private HashGNNCompanion() {
    }

    static void hashArgMin(HugeAtomicBitSet bitSet, int[] hashes, HashGNN.MinAndArgmin result, HashGNN.MinAndArgmin temp) {
        temp.argMin = -1;
        temp.min = Integer.MAX_VALUE;
        bitSet.forEachSetBit(bit -> {
            int hash = hashes[(int)bit];
            if (hash < temp.min) {
                temp.min = hash;
                temp.argMin = (int)bit;
            }
        });
        result.min = temp.min;
        result.argMin = temp.argMin;
    }

    static void hashArgMin(BitSet bitSet, int[] hashes, HashGNN.MinAndArgmin result) {
        int argMin = -1;
        int minHash = Integer.MAX_VALUE;
        BitSetIterator iterator = bitSet.iterator();
        int bit = iterator.nextSetBit();
        while (bit != -1) {
            int hash = hashes[bit];
            if (hash < minHash) {
                minHash = hash;
                argMin = bit;
            }
            bit = iterator.nextSetBit();
        }
        result.min = minHash;
        result.argMin = argMin;
    }

    @ValueClass
    static interface HashTriple {
        public int a();

        public int b();

        public int c();

        public static HashTriple generate(SplittableRandom rng) {
            int c = Primes.nextPrime((int)rng.nextInt(1, Integer.MAX_VALUE));
            return HashTriple.generate(rng, c);
        }

        public static HashTriple generate(SplittableRandom rng, int c) {
            int a = rng.nextInt(1, c);
            int b = rng.nextInt(1, c);
            return ImmutableHashTriple.of(a, b, c);
        }

        public static int[] computeHashesFromTriple(int embeddingDimension, HashTriple hashTriple) {
            int[] output = new int[embeddingDimension];
            for (int i = 0; i < embeddingDimension; ++i) {
                output[i] = Math.toIntExact(((long)i * (long)hashTriple.a() + (long)hashTriple.b()) % (long)hashTriple.c());
            }
            return output;
        }
    }
}

