/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.hashgnn.BinarizeFeaturesConfig;
import org.neo4j.gds.embeddings.hashgnn.BinarizeFeaturesConfigImpl;
import org.neo4j.gds.embeddings.hashgnn.GenerateFeaturesConfig;
import org.neo4j.gds.embeddings.hashgnn.GenerateFeaturesConfigImpl;

interface HashGNNConfig
extends AlgoBaseConfig,
FeaturePropertiesConfig,
RandomSeedConfig {
    @Configuration.IntegerRange(min=1)
    public int iterations();

    @Configuration.IntegerRange(min=1)
    public int embeddingDensity();

    @Configuration.IntegerRange(min=1)
    public Optional<Integer> outputDimension();

    @Configuration.DoubleRange(min=0.0)
    default public double neighborInfluence() {
        return 1.0;
    }

    default public boolean heterogeneous() {
        return false;
    }

    @Configuration.ToMapValue(value="org.neo4j.gds.embeddings.hashgnn.HashGNNConfig#toMapGenerateFeaturesConfig")
    @Configuration.ConvertWith(method="parseGenerateFeaturesConfig", inverse="__USE_TO_MAP_METHOD__")
    public Optional<GenerateFeaturesConfig> generateFeatures();

    @Configuration.ToMapValue(value="org.neo4j.gds.embeddings.hashgnn.HashGNNConfig#toMapBinarizationConfig")
    @Configuration.ConvertWith(method="parseBinarizationConfig", inverse="__USE_TO_MAP_METHOD__")
    public Optional<BinarizeFeaturesConfig> binarizeFeatures();

    @Value.Check
    default public void validate() {
        if (!this.featureProperties().isEmpty() && this.generateFeatures().isPresent()) {
            throw new IllegalArgumentException("It is not allowed to use `generateFeatures` and have non-empty `featureProperties`.");
        }
        if (this.generateFeatures().isPresent()) {
            return;
        }
        if (this.featureProperties().isEmpty()) {
            throw new IllegalArgumentException("When `generateFeatures` is not given, `featureProperties` must be non-empty.");
        }
    }

    public static BinarizeFeaturesConfig parseBinarizationConfig(Map<String, Object> parameter) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(parameter);
        BinarizeFeaturesConfigImpl binarizeFeaturesConfig = new BinarizeFeaturesConfigImpl((CypherMapAccess)cypherMapWrapper);
        cypherMapWrapper.requireOnlyKeysFrom(binarizeFeaturesConfig.configKeys());
        return binarizeFeaturesConfig;
    }

    public static Map<String, Object> toMapBinarizationConfig(BinarizeFeaturesConfig config) {
        return config.toMap();
    }

    public static GenerateFeaturesConfig parseGenerateFeaturesConfig(Map<String, Object> parameter) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(parameter);
        GenerateFeaturesConfigImpl generateFeaturesConfig = new GenerateFeaturesConfigImpl((CypherMapAccess)cypherMapWrapper);
        cypherMapWrapper.requireOnlyKeysFrom(generateFeaturesConfig.configKeys());
        return generateFeaturesConfig;
    }

    public static Map<String, Object> toMapGenerateFeaturesConfig(GenerateFeaturesConfig config) {
        return config.toMap();
    }
}

