/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.hashgnn.HashGNNCompanion;

@Generated(from="HashGNNCompanion.HashTriple", generator="Immutables")
public final class ImmutableHashTriple
implements HashGNNCompanion.HashTriple {
    private final int a;
    private final int b;
    private final int c;

    private ImmutableHashTriple(int a, int b, int c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public int b() {
        return this.b;
    }

    @Override
    public int c() {
        return this.c;
    }

    public final ImmutableHashTriple withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableHashTriple(value, this.b, this.c);
    }

    public final ImmutableHashTriple withB(int value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableHashTriple(this.a, value, this.c);
    }

    public final ImmutableHashTriple withC(int value) {
        if (this.c == value) {
            return this;
        }
        return new ImmutableHashTriple(this.a, this.b, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHashTriple && this.equalTo((ImmutableHashTriple)another);
    }

    private boolean equalTo(ImmutableHashTriple another) {
        return this.a == another.a && this.b == another.b && this.c == another.c;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b;
        h += (h << 5) + this.c;
        return h;
    }

    public String toString() {
        return "HashTriple{a=" + this.a + ", b=" + this.b + ", c=" + this.c + "}";
    }

    public static HashGNNCompanion.HashTriple of(int a, int b, int c) {
        return new ImmutableHashTriple(a, b, c);
    }

    static HashGNNCompanion.HashTriple copyOf(HashGNNCompanion.HashTriple instance) {
        if (instance instanceof ImmutableHashTriple) {
            return (ImmutableHashTriple)instance;
        }
        return ImmutableHashTriple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HashGNNCompanion.HashTriple", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private static final long INIT_BIT_C = 4L;
        private long initBits = 7L;
        private int a;
        private int b;
        private int c;

        private Builder() {
        }

        public final Builder from(ImmutableHashTriple instance) {
            return this.from((HashGNNCompanion.HashTriple)instance);
        }

        final Builder from(HashGNNCompanion.HashTriple instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.b(instance.b());
            this.c(instance.c());
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder b(int b) {
            this.b = b;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder c(int c) {
            this.c = c;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.a = 0;
            this.b = 0;
            this.c = 0;
            return this;
        }

        public HashGNNCompanion.HashTriple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHashTriple(this.a, this.b, this.c);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("c");
            }
            return "Cannot build HashTriple, some of required attributes are not set " + attributes;
        }
    }
}

