/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.hashgnn.HashTask;

@Generated(from="HashTask.Hashes", generator="Immutables")
public final class ImmutableHashes
implements HashTask.Hashes {
    private final int[] neighborsAggregationHashes;
    private final int[] selfAggregationHashes;
    private final List<int[]> preAggregationHashes;

    private ImmutableHashes(int[] neighborsAggregationHashes, int[] selfAggregationHashes, Iterable<? extends int[]> preAggregationHashes) {
        this.neighborsAggregationHashes = (int[])neighborsAggregationHashes.clone();
        this.selfAggregationHashes = (int[])selfAggregationHashes.clone();
        this.preAggregationHashes = ImmutableHashes.createUnmodifiableList(false, ImmutableHashes.createSafeList(preAggregationHashes, true, false));
    }

    private ImmutableHashes(ImmutableHashes original, int[] neighborsAggregationHashes, int[] selfAggregationHashes, List<int[]> preAggregationHashes) {
        this.neighborsAggregationHashes = neighborsAggregationHashes;
        this.selfAggregationHashes = selfAggregationHashes;
        this.preAggregationHashes = preAggregationHashes;
    }

    @Override
    public int[] neighborsAggregationHashes() {
        return (int[])this.neighborsAggregationHashes.clone();
    }

    @Override
    public int[] selfAggregationHashes() {
        return (int[])this.selfAggregationHashes.clone();
    }

    @Override
    public List<int[]> preAggregationHashes() {
        return this.preAggregationHashes;
    }

    public final ImmutableHashes withNeighborsAggregationHashes(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableHashes(this, newValue, this.selfAggregationHashes, this.preAggregationHashes);
    }

    public final ImmutableHashes withSelfAggregationHashes(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableHashes(this, this.neighborsAggregationHashes, newValue, this.preAggregationHashes);
    }

    public final ImmutableHashes withPreAggregationHashes(int[] ... elements) {
        List<int[]> newValue = ImmutableHashes.createUnmodifiableList(false, ImmutableHashes.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHashes(this, this.neighborsAggregationHashes, this.selfAggregationHashes, newValue);
    }

    public final ImmutableHashes withPreAggregationHashes(Iterable<? extends int[]> elements) {
        if (this.preAggregationHashes == elements) {
            return this;
        }
        List<int[]> newValue = ImmutableHashes.createUnmodifiableList(false, ImmutableHashes.createSafeList(elements, true, false));
        return new ImmutableHashes(this, this.neighborsAggregationHashes, this.selfAggregationHashes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHashes && this.equalTo((ImmutableHashes)another);
    }

    private boolean equalTo(ImmutableHashes another) {
        return Arrays.equals(this.neighborsAggregationHashes, another.neighborsAggregationHashes) && Arrays.equals(this.selfAggregationHashes, another.selfAggregationHashes) && this.preAggregationHashes.equals(another.preAggregationHashes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.neighborsAggregationHashes);
        h += (h << 5) + Arrays.hashCode(this.selfAggregationHashes);
        h += (h << 5) + this.preAggregationHashes.hashCode();
        return h;
    }

    public String toString() {
        return "Hashes{neighborsAggregationHashes=" + Arrays.toString(this.neighborsAggregationHashes) + ", selfAggregationHashes=" + Arrays.toString(this.selfAggregationHashes) + ", preAggregationHashes=" + this.preAggregationHashes + "}";
    }

    public static HashTask.Hashes of(int[] neighborsAggregationHashes, int[] selfAggregationHashes, List<int[]> preAggregationHashes) {
        return ImmutableHashes.of(neighborsAggregationHashes, selfAggregationHashes, preAggregationHashes);
    }

    public static HashTask.Hashes of(int[] neighborsAggregationHashes, int[] selfAggregationHashes, Iterable<? extends int[]> preAggregationHashes) {
        return new ImmutableHashes(neighborsAggregationHashes, selfAggregationHashes, preAggregationHashes);
    }

    static HashTask.Hashes copyOf(HashTask.Hashes instance) {
        if (instance instanceof ImmutableHashes) {
            return (ImmutableHashes)instance;
        }
        return ImmutableHashes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HashTask.Hashes", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_NEIGHBORS_AGGREGATION_HASHES = 1L;
        private static final long INIT_BIT_SELF_AGGREGATION_HASHES = 2L;
        private long initBits = 3L;
        private int[] neighborsAggregationHashes;
        private int[] selfAggregationHashes;
        private List<int[]> preAggregationHashes = null;

        private Builder() {
        }

        public final Builder from(ImmutableHashes instance) {
            return this.from((HashTask.Hashes)instance);
        }

        final Builder from(HashTask.Hashes instance) {
            Objects.requireNonNull(instance, "instance");
            this.neighborsAggregationHashes(instance.neighborsAggregationHashes());
            this.selfAggregationHashes(instance.selfAggregationHashes());
            this.addAllPreAggregationHashes(instance.preAggregationHashes());
            return this;
        }

        public final Builder neighborsAggregationHashes(int ... neighborsAggregationHashes) {
            this.neighborsAggregationHashes = (int[])neighborsAggregationHashes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder selfAggregationHashes(int ... selfAggregationHashes) {
            this.selfAggregationHashes = (int[])selfAggregationHashes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPreAggregationHashe(int[] element) {
            if (this.preAggregationHashes == null) {
                this.preAggregationHashes = new ArrayList<int[]>();
            }
            this.preAggregationHashes.add(Objects.requireNonNull(element, "preAggregationHashes element"));
            return this;
        }

        public final Builder addPreAggregationHashes(int[] ... elements) {
            if (this.preAggregationHashes == null) {
                this.preAggregationHashes = new ArrayList<int[]>();
            }
            for (int[] element : elements) {
                this.preAggregationHashes.add(Objects.requireNonNull(element, "preAggregationHashes element"));
            }
            return this;
        }

        public final Builder preAggregationHashes(Iterable<? extends int[]> elements) {
            this.preAggregationHashes = new ArrayList<int[]>();
            return this.addAllPreAggregationHashes(elements);
        }

        public final Builder addAllPreAggregationHashes(Iterable<? extends int[]> elements) {
            Objects.requireNonNull(elements, "preAggregationHashes element");
            if (this.preAggregationHashes == null) {
                this.preAggregationHashes = new ArrayList<int[]>();
            }
            for (int[] nArray : elements) {
                this.preAggregationHashes.add(Objects.requireNonNull(nArray, "preAggregationHashes element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.neighborsAggregationHashes = null;
            this.selfAggregationHashes = null;
            if (this.preAggregationHashes != null) {
                this.preAggregationHashes.clear();
            }
            return this;
        }

        public HashTask.Hashes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHashes(null, this.neighborsAggregationHashes, this.selfAggregationHashes, this.preAggregationHashes == null ? Collections.emptyList() : ImmutableHashes.createUnmodifiableList(true, this.preAggregationHashes));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("neighborsAggregationHashes");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("selfAggregationHashes");
            }
            return "Cannot build Hashes, some of required attributes are not set " + attributes;
        }
    }
}

