/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.embeddings.hashgnn.HashGNNConfig;
import org.neo4j.gds.ml.core.features.FeatureConsumer;
import org.neo4j.gds.ml.core.features.FeatureExtraction;
import org.neo4j.gds.ml.core.features.FeatureExtractor;
import org.neo4j.gds.utils.StringFormatting;

class RawFeaturesTask
implements Runnable {
    private final Partition partition;
    private final Graph graph;
    private final List<FeatureExtractor> featureExtractors;
    private final int inputDimension;
    private final HugeObjectArray<HugeAtomicBitSet> features;
    private final ProgressTracker progressTracker;
    private long totalFeatureCount = 0L;

    RawFeaturesTask(Partition partition, Graph graph, List<FeatureExtractor> featureExtractors, int inputDimension, HugeObjectArray<HugeAtomicBitSet> features, ProgressTracker progressTracker) {
        this.partition = partition;
        this.graph = graph;
        this.featureExtractors = featureExtractors;
        this.inputDimension = inputDimension;
        this.features = features;
        this.progressTracker = progressTracker;
    }

    static HugeObjectArray<HugeAtomicBitSet> compute(HashGNNConfig config, ProgressTracker progressTracker, Graph graph, List<Partition> partitions, TerminationFlag terminationFlag, MutableLong totalFeatureCountOutput) {
        progressTracker.beginSubTask("Extract raw node property features");
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, (Collection)config.featureProperties());
        int inputDimension = FeatureExtraction.featureCount((Collection)featureExtractors);
        HugeObjectArray features = HugeObjectArray.newArray(HugeAtomicBitSet.class, (long)graph.nodeCount());
        List tasks = partitions.stream().map(p -> new RawFeaturesTask((Partition)p, graph, featureExtractors, inputDimension, (HugeObjectArray<HugeAtomicBitSet>)features, progressTracker)).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(config.concurrency()).tasks(tasks).terminationFlag(terminationFlag).run();
        totalFeatureCountOutput.add(tasks.stream().mapToLong(RawFeaturesTask::totalFeatureCount).sum());
        progressTracker.endSubTask("Extract raw node property features");
        return features;
    }

    @Override
    public void run() {
        this.partition.consume(nodeId -> {
            final HugeAtomicBitSet nodeFeatures = HugeAtomicBitSet.create((long)this.inputDimension);
            FeatureExtraction.extract((long)nodeId, (long)-1L, this.featureExtractors, (FeatureConsumer)new FeatureConsumer(){

                public void acceptScalar(long nodeOffset, int offset, double value) {
                    if (value == 1.0) {
                        nodeFeatures.set((long)offset);
                    } else if (value != 0.0) {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Feature properties may only contain values 0 and 1 unless `binarizeFeatures` is used. Node %d and possibly other nodes have a feature property containing value %f", (Object[])new Object[]{RawFeaturesTask.this.graph.toOriginalNodeId(nodeId), value}));
                    }
                }

                public void acceptArray(long nodeOffset, int offset, double[] values) {
                    for (int inputFeatureOffset = 0; inputFeatureOffset < values.length; ++inputFeatureOffset) {
                        double value = values[inputFeatureOffset];
                        if (value == 1.0) {
                            nodeFeatures.set((long)(offset + inputFeatureOffset));
                            continue;
                        }
                        if (value == 0.0) continue;
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Feature properties may only contain values 0 and 1 unless `binarizeFeatures` is used. Node %d and possibly other nodes have a feature property containing value %.17f", (Object[])new Object[]{RawFeaturesTask.this.graph.toOriginalNodeId(nodeId), value}));
                    }
                }
            });
            this.totalFeatureCount += nodeFeatures.cardinality();
            this.features.set(nodeId, (Object)nodeFeatures);
        });
        this.progressTracker.logProgress(this.partition.nodeCount());
    }

    public long totalFeatureCount() {
        return this.totalFeatureCount;
    }
}

