/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.gds.core.loading.VarLongEncoding;
import org.neo4j.gds.core.loading.ZigZagLongDecoding;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.utils.StringFormatting;

public class CompressedRandomWalks {
    private final HugeObjectArray<byte[]> compressedWalks;
    private final HugeIntArray walkLengths;
    private int maxWalkLength;
    private long size = 0L;

    public CompressedRandomWalks(long maxWalkCount) {
        this.compressedWalks = HugeObjectArray.newArray(byte[].class, (long)maxWalkCount);
        this.walkLengths = HugeIntArray.newArray((long)maxWalkCount);
    }

    public void add(long ... walk) {
        long currentLastValue = 0L;
        int requiredBytes = 0;
        for (int i = 0; i < walk.length; ++i) {
            long delta = walk[i] - currentLastValue;
            long compressedValue = VarLongEncoding.zigZag((long)delta);
            currentLastValue = walk[i];
            walk[i] = compressedValue;
            requiredBytes += VarLongEncoding.encodedVLongSize((long)compressedValue);
        }
        byte[] compressedData = new byte[requiredBytes];
        VarLongEncoding.encodeVLongs((long[])walk, (int)walk.length, (byte[])compressedData, (int)0);
        long currentIndex = this.size++;
        this.compressedWalks.set(currentIndex, (Object)compressedData);
        this.walkLengths.set(currentIndex, walk.length);
        if (walk.length > this.maxWalkLength) {
            this.maxWalkLength = walk.length;
        }
    }

    public Iterator<long[]> iterator(long startIndex, long length) {
        long endIndex = startIndex + length - 1L;
        if (startIndex >= this.size() || endIndex >= this.size()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Requested iterator chunk exceeds the number of stored random walks. Requested %d-%d, actual size %d", (Object[])new Object[]{startIndex, endIndex, this.size()}));
        }
        return new CompressedWalkIterator(startIndex, endIndex, this.compressedWalks, this.walkLengths, this.maxWalkLength);
    }

    public long size() {
        return this.size;
    }

    public int walkLength(long index) {
        return this.walkLengths.get(index);
    }

    public static class CompressedWalkIterator
    extends AbstractIterator<long[]> {
        private final HugeCursor<byte[][]> cursor;
        private final HugeIntArray walkLengths;
        private final long[] outputBuffer;
        private int currentIndex;

        CompressedWalkIterator(long startIndex, long endIndex, HugeObjectArray<byte[]> compressedWalks, HugeIntArray walkLengths, int maxWalkLength) {
            this.walkLengths = walkLengths;
            this.cursor = compressedWalks.newCursor();
            compressedWalks.initCursor(this.cursor, startIndex, endIndex + 1L);
            this.cursor.next();
            this.currentIndex = this.cursor.offset;
            this.outputBuffer = new long[maxWalkLength];
        }

        protected long[] fetch() {
            if (this.currentIndex >= this.cursor.limit) {
                if (!this.cursor.next()) {
                    return (long[])this.done();
                }
                this.currentIndex = this.cursor.offset;
            }
            byte[] compressedWalk = ((byte[][])this.cursor.array)[this.currentIndex];
            int walkLength = this.walkLengths.get(this.cursor.base + (long)this.currentIndex);
            Arrays.fill(this.outputBuffer, -1L);
            ZigZagLongDecoding.zigZagUncompress((byte[])compressedWalk, (int)walkLength, (long[])this.outputBuffer);
            ++this.currentIndex;
            return this.outputBuffer;
        }
    }
}

