/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.embeddings.node2vec.Node2VecWriteConfig;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;

@Generated(from="Node2VecWriteConfig", generator="Immutables")
public final class ImmutableNode2VecWriteConfig
implements Node2VecWriteConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final Long randomSeed;
    private final int walkLength;
    private final int walksPerNode;
    private final int walkBufferSize;
    private final double inOutFactor;
    private final double returnFactor;
    private final int windowSize;
    private final int negativeSamplingRate;
    private final double positiveSamplingFactor;
    private final double negativeSamplingExponent;
    private final int embeddingDimension;
    private final Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer;
    private final double initialLearningRate;
    private final double minLearningRate;
    private final int iterations;
    private final List<Long> sourceNodes;
    private final int writeConcurrency;
    private final String writeProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNode2VecWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.embeddingInitializer(Objects.requireNonNull(embeddingInitializer, "embeddingInitializer"));
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.embeddingInitializer = this.initShim.embeddingInitializer();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNode2VecWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.embeddingInitializer(Objects.requireNonNull(embeddingInitializer, "embeddingInitializer"));
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.embeddingInitializer = this.initShim.embeddingInitializer();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNode2VecWriteConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.randomSeed = builder.randomSeed;
        this.writeProperty = builder.writeProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNode2VecWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNode2VecWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.walkLengthIsSet()) {
            this.initShim.walkLength(builder.walkLength);
        }
        if (builder.walksPerNodeIsSet()) {
            this.initShim.walksPerNode(builder.walksPerNode);
        }
        if (builder.walkBufferSizeIsSet()) {
            this.initShim.walkBufferSize(builder.walkBufferSize);
        }
        if (builder.inOutFactorIsSet()) {
            this.initShim.inOutFactor(builder.inOutFactor);
        }
        if (builder.returnFactorIsSet()) {
            this.initShim.returnFactor(builder.returnFactor);
        }
        if (builder.windowSizeIsSet()) {
            this.initShim.windowSize(builder.windowSize);
        }
        if (builder.negativeSamplingRateIsSet()) {
            this.initShim.negativeSamplingRate(builder.negativeSamplingRate);
        }
        if (builder.positiveSamplingFactorIsSet()) {
            this.initShim.positiveSamplingFactor(builder.positiveSamplingFactor);
        }
        if (builder.negativeSamplingExponentIsSet()) {
            this.initShim.negativeSamplingExponent(builder.negativeSamplingExponent);
        }
        if (builder.embeddingDimensionIsSet()) {
            this.initShim.embeddingDimension(builder.embeddingDimension);
        }
        if (builder.embeddingInitializer != null) {
            this.initShim.embeddingInitializer(builder.embeddingInitializer);
        }
        if (builder.initialLearningRateIsSet()) {
            this.initShim.initialLearningRate(builder.initialLearningRate);
        }
        if (builder.minLearningRateIsSet()) {
            this.initShim.minLearningRate(builder.minLearningRate);
        }
        if (builder.iterationsIsSet()) {
            this.initShim.iterations(builder.iterations);
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutableNode2VecWriteConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.embeddingInitializer = this.initShim.embeddingInitializer();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNode2VecWriteConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, List<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.embeddingInitializer(embeddingInitializer);
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.embeddingInitializer = this.initShim.embeddingInitializer();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return Node2VecWriteConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return Node2VecWriteConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return Node2VecWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return Node2VecWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return Node2VecWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return Node2VecWriteConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return Node2VecWriteConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return Node2VecWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return Node2VecWriteConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return Node2VecWriteConfig.super.hasRelationshipWeightProperty();
    }

    private int walkLengthInitialize() {
        return Node2VecWriteConfig.super.walkLength();
    }

    private int walksPerNodeInitialize() {
        return Node2VecWriteConfig.super.walksPerNode();
    }

    private int walkBufferSizeInitialize() {
        return Node2VecWriteConfig.super.walkBufferSize();
    }

    private double inOutFactorInitialize() {
        return Node2VecWriteConfig.super.inOutFactor();
    }

    private double returnFactorInitialize() {
        return Node2VecWriteConfig.super.returnFactor();
    }

    private int windowSizeInitialize() {
        return Node2VecWriteConfig.super.windowSize();
    }

    private int negativeSamplingRateInitialize() {
        return Node2VecWriteConfig.super.negativeSamplingRate();
    }

    private double positiveSamplingFactorInitialize() {
        return Node2VecWriteConfig.super.positiveSamplingFactor();
    }

    private double negativeSamplingExponentInitialize() {
        return Node2VecWriteConfig.super.negativeSamplingExponent();
    }

    private int embeddingDimensionInitialize() {
        return Node2VecWriteConfig.super.embeddingDimension();
    }

    private Node2VecBaseConfig.EmbeddingInitializer embeddingInitializerInitialize() {
        return Node2VecWriteConfig.super.embeddingInitializer();
    }

    private double initialLearningRateInitialize() {
        return Node2VecWriteConfig.super.initialLearningRate();
    }

    private double minLearningRateInitialize() {
        return Node2VecWriteConfig.super.minLearningRate();
    }

    private int iterationsInitialize() {
        return Node2VecWriteConfig.super.iterations();
    }

    private List<Long> sourceNodesInitialize() {
        return Node2VecWriteConfig.super.sourceNodes();
    }

    private int writeConcurrencyInitialize() {
        return Node2VecWriteConfig.super.writeConcurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int walkLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkLength() : this.walkLength;
    }

    @Override
    public int walksPerNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walksPerNode() : this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkBufferSize() : this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inOutFactor() : this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnFactor() : this.returnFactor;
    }

    @Override
    public int windowSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.windowSize() : this.windowSize;
    }

    @Override
    public int negativeSamplingRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSamplingRate() : this.negativeSamplingRate;
    }

    @Override
    public double positiveSamplingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.positiveSamplingFactor() : this.positiveSamplingFactor;
    }

    @Override
    public double negativeSamplingExponent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSamplingExponent() : this.negativeSamplingExponent;
    }

    @Override
    public int embeddingDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeddingDimension() : this.embeddingDimension;
    }

    @Override
    public Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeddingInitializer() : this.embeddingInitializer;
    }

    @Override
    public double initialLearningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialLearningRate() : this.initialLearningRate;
    }

    @Override
    public double minLearningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minLearningRate() : this.minLearningRate;
    }

    @Override
    public int iterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterations() : this.iterations;
    }

    @Override
    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public final ImmutableNode2VecWriteConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWalkLength(int value) {
        if (this.walkLength == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, value, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWalksPerNode(int value) {
        if (this.walksPerNode == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, value, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWalkBufferSize(int value) {
        if (this.walkBufferSize == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, value, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withInOutFactor(double value) {
        if (Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, value, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withReturnFactor(double value) {
        if (Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, value, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWindowSize(int value) {
        if (this.windowSize == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, value, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withNegativeSamplingRate(int value) {
        if (this.negativeSamplingRate == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, value, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withPositiveSamplingFactor(double value) {
        if (Double.doubleToLongBits(this.positiveSamplingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, value, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withNegativeSamplingExponent(double value) {
        if (Double.doubleToLongBits(this.negativeSamplingExponent) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, value, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, value, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withEmbeddingInitializer(Node2VecBaseConfig.EmbeddingInitializer value) {
        if (this.embeddingInitializer == value) {
            return this;
        }
        Node2VecBaseConfig.EmbeddingInitializer newValue = Objects.requireNonNull(value, "embeddingInitializer");
        if (this.embeddingInitializer.equals((Object)newValue)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, newValue, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withInitialLearningRate(double value) {
        if (Double.doubleToLongBits(this.initialLearningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, value, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withMinLearningRate(double value) {
        if (Double.doubleToLongBits(this.minLearningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, value, this.iterations, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withIterations(int value) {
        if (this.iterations == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, value, this.sourceNodes, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, newValue, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, newValue, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, value, this.writeProperty));
    }

    public final ImmutableNode2VecWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.embeddingInitializer, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes, this.writeConcurrency, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode2VecWriteConfig && this.equalTo((ImmutableNode2VecWriteConfig)another);
    }

    private boolean equalTo(ImmutableNode2VecWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.randomSeed, another.randomSeed) && this.walkLength == another.walkLength && this.walksPerNode == another.walksPerNode && this.walkBufferSize == another.walkBufferSize && Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(another.inOutFactor) && Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(another.returnFactor) && this.windowSize == another.windowSize && this.negativeSamplingRate == another.negativeSamplingRate && Double.doubleToLongBits(this.positiveSamplingFactor) == Double.doubleToLongBits(another.positiveSamplingFactor) && Double.doubleToLongBits(this.negativeSamplingExponent) == Double.doubleToLongBits(another.negativeSamplingExponent) && this.embeddingDimension == another.embeddingDimension && this.embeddingInitializer.equals((Object)another.embeddingInitializer) && Double.doubleToLongBits(this.initialLearningRate) == Double.doubleToLongBits(another.initialLearningRate) && Double.doubleToLongBits(this.minLearningRate) == Double.doubleToLongBits(another.minLearningRate) && this.iterations == another.iterations && this.sourceNodes.equals(another.sourceNodes) && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.walkLength;
        h += (h << 5) + this.walksPerNode;
        h += (h << 5) + this.walkBufferSize;
        h += (h << 5) + Double.hashCode(this.inOutFactor);
        h += (h << 5) + Double.hashCode(this.returnFactor);
        h += (h << 5) + this.windowSize;
        h += (h << 5) + this.negativeSamplingRate;
        h += (h << 5) + Double.hashCode(this.positiveSamplingFactor);
        h += (h << 5) + Double.hashCode(this.negativeSamplingExponent);
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + this.embeddingInitializer.hashCode();
        h += (h << 5) + Double.hashCode(this.initialLearningRate);
        h += (h << 5) + Double.hashCode(this.minLearningRate);
        h += (h << 5) + this.iterations;
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Node2VecWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("walkLength=").append(this.walkLength);
        builder.append(", ");
        builder.append("walksPerNode=").append(this.walksPerNode);
        builder.append(", ");
        builder.append("walkBufferSize=").append(this.walkBufferSize);
        builder.append(", ");
        builder.append("inOutFactor=").append(this.inOutFactor);
        builder.append(", ");
        builder.append("returnFactor=").append(this.returnFactor);
        builder.append(", ");
        builder.append("windowSize=").append(this.windowSize);
        builder.append(", ");
        builder.append("negativeSamplingRate=").append(this.negativeSamplingRate);
        builder.append(", ");
        builder.append("positiveSamplingFactor=").append(this.positiveSamplingFactor);
        builder.append(", ");
        builder.append("negativeSamplingExponent=").append(this.negativeSamplingExponent);
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        builder.append(", ");
        builder.append("embeddingInitializer=").append((Object)this.embeddingInitializer);
        builder.append(", ");
        builder.append("initialLearningRate=").append(this.initialLearningRate);
        builder.append(", ");
        builder.append("minLearningRate=").append(this.minLearningRate);
        builder.append(", ");
        builder.append("iterations=").append(this.iterations);
        builder.append(", ");
        builder.append("sourceNodes=").append(this.sourceNodes);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        return builder.append("}").toString();
    }

    public static Node2VecWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, List<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        return ImmutableNode2VecWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, embeddingInitializer, initialLearningRate, minLearningRate, iterations, sourceNodes, writeConcurrency, writeProperty);
    }

    public static Node2VecWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, embeddingInitializer, initialLearningRate, minLearningRate, iterations, sourceNodes, writeConcurrency, writeProperty));
    }

    public static Node2VecWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes, int writeConcurrency, String writeProperty) {
        return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, embeddingInitializer, initialLearningRate, minLearningRate, iterations, sourceNodes, writeConcurrency, writeProperty));
    }

    private static ImmutableNode2VecWriteConfig validate(ImmutableNode2VecWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static Node2VecWriteConfig copyOf(Node2VecWriteConfig instance) {
        if (instance instanceof ImmutableNode2VecWriteConfig) {
            return (ImmutableNode2VecWriteConfig)instance;
        }
        return ImmutableNode2VecWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Node2VecWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_WALK_LENGTH = 64L;
        private static final long OPT_BIT_WALKS_PER_NODE = 128L;
        private static final long OPT_BIT_WALK_BUFFER_SIZE = 256L;
        private static final long OPT_BIT_IN_OUT_FACTOR = 512L;
        private static final long OPT_BIT_RETURN_FACTOR = 1024L;
        private static final long OPT_BIT_WINDOW_SIZE = 2048L;
        private static final long OPT_BIT_NEGATIVE_SAMPLING_RATE = 4096L;
        private static final long OPT_BIT_POSITIVE_SAMPLING_FACTOR = 8192L;
        private static final long OPT_BIT_NEGATIVE_SAMPLING_EXPONENT = 16384L;
        private static final long OPT_BIT_EMBEDDING_DIMENSION = 32768L;
        private static final long OPT_BIT_INITIAL_LEARNING_RATE = 65536L;
        private static final long OPT_BIT_MIN_LEARNING_RATE = 131072L;
        private static final long OPT_BIT_ITERATIONS = 262144L;
        private static final long OPT_BIT_SOURCE_NODES = 524288L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 0x100000L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private Long randomSeed;
        private int walkLength;
        private int walksPerNode;
        private int walkBufferSize;
        private double inOutFactor;
        private double returnFactor;
        private int windowSize;
        private int negativeSamplingRate;
        private double positiveSamplingFactor;
        private double negativeSamplingExponent;
        private int embeddingDimension;
        private Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer;
        private double initialLearningRate;
        private double minLearningRate;
        private int iterations;
        private List<Long> sourceNodes = null;
        private int writeConcurrency;
        private String writeProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Node2VecBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Node2VecWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            Optional relationshipWeightPropertyOptional;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof Node2VecBaseConfig) {
                instance = (Node2VecBaseConfig)object;
                this.negativeSamplingExponent(instance.negativeSamplingExponent());
                this.windowSize(instance.windowSize());
                this.initialLearningRate(instance.initialLearningRate());
                this.negativeSamplingRate(instance.negativeSamplingRate());
                if ((bits & 1L) == 0L) {
                    this.addAllSourceNodes(instance.sourceNodes());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
                this.positiveSamplingFactor(instance.positiveSamplingFactor());
                this.embeddingInitializer(instance.embeddingInitializer());
                this.minLearningRate(instance.minLearningRate());
                this.iterations(instance.iterations());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof RandomWalkBaseConfig) {
                instance = (RandomWalkBaseConfig)object;
                this.walkLength(instance.walkLength());
                this.walksPerNode(instance.walksPerNode());
                this.walkBufferSize(instance.walkBufferSize());
                this.returnFactor(instance.returnFactor());
                this.inOutFactor(instance.inOutFactor());
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                if ((bits & 1L) == 0L) {
                    this.addAllSourceNodes(instance.sourceNodes());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder negativeSamplingRate(int negativeSamplingRate) {
            this.negativeSamplingRate = negativeSamplingRate;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder positiveSamplingFactor(double positiveSamplingFactor) {
            this.positiveSamplingFactor = positiveSamplingFactor;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder negativeSamplingExponent(double negativeSamplingExponent) {
            this.negativeSamplingExponent = negativeSamplingExponent;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder embeddingInitializer(Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer) {
            this.embeddingInitializer = Objects.requireNonNull(embeddingInitializer, "embeddingInitializer");
            return this;
        }

        public final Builder initialLearningRate(double initialLearningRate) {
            this.initialLearningRate = initialLearningRate;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            this.optBits |= 0x20000L;
            return this;
        }

        public final Builder iterations(int iterations) {
            this.iterations = iterations;
            this.optBits |= 0x40000L;
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x100000L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.randomSeed = null;
            this.walkLength = 0;
            this.walksPerNode = 0;
            this.walkBufferSize = 0;
            this.inOutFactor = 0.0;
            this.returnFactor = 0.0;
            this.windowSize = 0;
            this.negativeSamplingRate = 0;
            this.positiveSamplingFactor = 0.0;
            this.negativeSamplingExponent = 0.0;
            this.embeddingDimension = 0;
            this.embeddingInitializer = null;
            this.initialLearningRate = 0.0;
            this.minLearningRate = 0.0;
            this.iterations = 0;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.writeConcurrency = 0;
            this.writeProperty = null;
            return this;
        }

        public Node2VecWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNode2VecWriteConfig.validate(new ImmutableNode2VecWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean walkLengthIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean walksPerNodeIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean walkBufferSizeIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean inOutFactorIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean returnFactorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean windowSizeIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean negativeSamplingRateIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean positiveSamplingFactorIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean negativeSamplingExponentIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean embeddingDimensionIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean initialLearningRateIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean minLearningRateIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean iterationsIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x100000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build Node2VecWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Node2VecWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte walkLengthBuildStage = 0;
        private int walkLength;
        private byte walksPerNodeBuildStage = 0;
        private int walksPerNode;
        private byte walkBufferSizeBuildStage = 0;
        private int walkBufferSize;
        private byte inOutFactorBuildStage = 0;
        private double inOutFactor;
        private byte returnFactorBuildStage = 0;
        private double returnFactor;
        private byte windowSizeBuildStage = 0;
        private int windowSize;
        private byte negativeSamplingRateBuildStage = 0;
        private int negativeSamplingRate;
        private byte positiveSamplingFactorBuildStage = 0;
        private double positiveSamplingFactor;
        private byte negativeSamplingExponentBuildStage = 0;
        private double negativeSamplingExponent;
        private byte embeddingDimensionBuildStage = 0;
        private int embeddingDimension;
        private byte embeddingInitializerBuildStage = 0;
        private Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer;
        private byte initialLearningRateBuildStage = 0;
        private double initialLearningRate;
        private byte minLearningRateBuildStage = 0;
        private double minLearningRate;
        private byte iterationsBuildStage = 0;
        private int iterations;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNode2VecWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableNode2VecWriteConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNode2VecWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNode2VecWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNode2VecWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNode2VecWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableNode2VecWriteConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(ImmutableNode2VecWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(ImmutableNode2VecWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableNode2VecWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        int walkLength() {
            if (this.walkLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkLengthBuildStage == 0) {
                this.walkLengthBuildStage = (byte)-1;
                this.walkLength = ImmutableNode2VecWriteConfig.this.walkLengthInitialize();
                this.walkLengthBuildStage = 1;
            }
            return this.walkLength;
        }

        void walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.walkLengthBuildStage = 1;
        }

        int walksPerNode() {
            if (this.walksPerNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walksPerNodeBuildStage == 0) {
                this.walksPerNodeBuildStage = (byte)-1;
                this.walksPerNode = ImmutableNode2VecWriteConfig.this.walksPerNodeInitialize();
                this.walksPerNodeBuildStage = 1;
            }
            return this.walksPerNode;
        }

        void walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.walksPerNodeBuildStage = 1;
        }

        int walkBufferSize() {
            if (this.walkBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkBufferSizeBuildStage == 0) {
                this.walkBufferSizeBuildStage = (byte)-1;
                this.walkBufferSize = ImmutableNode2VecWriteConfig.this.walkBufferSizeInitialize();
                this.walkBufferSizeBuildStage = 1;
            }
            return this.walkBufferSize;
        }

        void walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.walkBufferSizeBuildStage = 1;
        }

        double inOutFactor() {
            if (this.inOutFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inOutFactorBuildStage == 0) {
                this.inOutFactorBuildStage = (byte)-1;
                this.inOutFactor = ImmutableNode2VecWriteConfig.this.inOutFactorInitialize();
                this.inOutFactorBuildStage = 1;
            }
            return this.inOutFactor;
        }

        void inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.inOutFactorBuildStage = 1;
        }

        double returnFactor() {
            if (this.returnFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnFactorBuildStage == 0) {
                this.returnFactorBuildStage = (byte)-1;
                this.returnFactor = ImmutableNode2VecWriteConfig.this.returnFactorInitialize();
                this.returnFactorBuildStage = 1;
            }
            return this.returnFactor;
        }

        void returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.returnFactorBuildStage = 1;
        }

        int windowSize() {
            if (this.windowSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.windowSizeBuildStage == 0) {
                this.windowSizeBuildStage = (byte)-1;
                this.windowSize = ImmutableNode2VecWriteConfig.this.windowSizeInitialize();
                this.windowSizeBuildStage = 1;
            }
            return this.windowSize;
        }

        void windowSize(int windowSize) {
            this.windowSize = windowSize;
            this.windowSizeBuildStage = 1;
        }

        int negativeSamplingRate() {
            if (this.negativeSamplingRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSamplingRateBuildStage == 0) {
                this.negativeSamplingRateBuildStage = (byte)-1;
                this.negativeSamplingRate = ImmutableNode2VecWriteConfig.this.negativeSamplingRateInitialize();
                this.negativeSamplingRateBuildStage = 1;
            }
            return this.negativeSamplingRate;
        }

        void negativeSamplingRate(int negativeSamplingRate) {
            this.negativeSamplingRate = negativeSamplingRate;
            this.negativeSamplingRateBuildStage = 1;
        }

        double positiveSamplingFactor() {
            if (this.positiveSamplingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.positiveSamplingFactorBuildStage == 0) {
                this.positiveSamplingFactorBuildStage = (byte)-1;
                this.positiveSamplingFactor = ImmutableNode2VecWriteConfig.this.positiveSamplingFactorInitialize();
                this.positiveSamplingFactorBuildStage = 1;
            }
            return this.positiveSamplingFactor;
        }

        void positiveSamplingFactor(double positiveSamplingFactor) {
            this.positiveSamplingFactor = positiveSamplingFactor;
            this.positiveSamplingFactorBuildStage = 1;
        }

        double negativeSamplingExponent() {
            if (this.negativeSamplingExponentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSamplingExponentBuildStage == 0) {
                this.negativeSamplingExponentBuildStage = (byte)-1;
                this.negativeSamplingExponent = ImmutableNode2VecWriteConfig.this.negativeSamplingExponentInitialize();
                this.negativeSamplingExponentBuildStage = 1;
            }
            return this.negativeSamplingExponent;
        }

        void negativeSamplingExponent(double negativeSamplingExponent) {
            this.negativeSamplingExponent = negativeSamplingExponent;
            this.negativeSamplingExponentBuildStage = 1;
        }

        int embeddingDimension() {
            if (this.embeddingDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embeddingDimensionBuildStage == 0) {
                this.embeddingDimensionBuildStage = (byte)-1;
                this.embeddingDimension = ImmutableNode2VecWriteConfig.this.embeddingDimensionInitialize();
                this.embeddingDimensionBuildStage = 1;
            }
            return this.embeddingDimension;
        }

        void embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.embeddingDimensionBuildStage = 1;
        }

        Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer() {
            if (this.embeddingInitializerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embeddingInitializerBuildStage == 0) {
                this.embeddingInitializerBuildStage = (byte)-1;
                this.embeddingInitializer = Objects.requireNonNull(ImmutableNode2VecWriteConfig.this.embeddingInitializerInitialize(), "embeddingInitializer");
                this.embeddingInitializerBuildStage = 1;
            }
            return this.embeddingInitializer;
        }

        void embeddingInitializer(Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer) {
            this.embeddingInitializer = embeddingInitializer;
            this.embeddingInitializerBuildStage = 1;
        }

        double initialLearningRate() {
            if (this.initialLearningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialLearningRateBuildStage == 0) {
                this.initialLearningRateBuildStage = (byte)-1;
                this.initialLearningRate = ImmutableNode2VecWriteConfig.this.initialLearningRateInitialize();
                this.initialLearningRateBuildStage = 1;
            }
            return this.initialLearningRate;
        }

        void initialLearningRate(double initialLearningRate) {
            this.initialLearningRate = initialLearningRate;
            this.initialLearningRateBuildStage = 1;
        }

        double minLearningRate() {
            if (this.minLearningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minLearningRateBuildStage == 0) {
                this.minLearningRateBuildStage = (byte)-1;
                this.minLearningRate = ImmutableNode2VecWriteConfig.this.minLearningRateInitialize();
                this.minLearningRateBuildStage = 1;
            }
            return this.minLearningRate;
        }

        void minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            this.minLearningRateBuildStage = 1;
        }

        int iterations() {
            if (this.iterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationsBuildStage == 0) {
                this.iterationsBuildStage = (byte)-1;
                this.iterations = ImmutableNode2VecWriteConfig.this.iterationsInitialize();
                this.iterationsBuildStage = 1;
            }
            return this.iterations;
        }

        void iterations(int iterations) {
            this.iterations = iterations;
            this.iterationsBuildStage = 1;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutableNode2VecWriteConfig.createUnmodifiableList(false, ImmutableNode2VecWriteConfig.createSafeList(ImmutableNode2VecWriteConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableNode2VecWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.walkLengthBuildStage == -1) {
                attributes.add("walkLength");
            }
            if (this.walksPerNodeBuildStage == -1) {
                attributes.add("walksPerNode");
            }
            if (this.walkBufferSizeBuildStage == -1) {
                attributes.add("walkBufferSize");
            }
            if (this.inOutFactorBuildStage == -1) {
                attributes.add("inOutFactor");
            }
            if (this.returnFactorBuildStage == -1) {
                attributes.add("returnFactor");
            }
            if (this.windowSizeBuildStage == -1) {
                attributes.add("windowSize");
            }
            if (this.negativeSamplingRateBuildStage == -1) {
                attributes.add("negativeSamplingRate");
            }
            if (this.positiveSamplingFactorBuildStage == -1) {
                attributes.add("positiveSamplingFactor");
            }
            if (this.negativeSamplingExponentBuildStage == -1) {
                attributes.add("negativeSamplingExponent");
            }
            if (this.embeddingDimensionBuildStage == -1) {
                attributes.add("embeddingDimension");
            }
            if (this.embeddingInitializerBuildStage == -1) {
                attributes.add("embeddingInitializer");
            }
            if (this.initialLearningRateBuildStage == -1) {
                attributes.add("initialLearningRate");
            }
            if (this.minLearningRateBuildStage == -1) {
                attributes.add("minLearningRate");
            }
            if (this.iterationsBuildStage == -1) {
                attributes.add("iterations");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build Node2VecWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

