/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.node2vec.Node2VecModel;
import org.neo4j.gds.ml.core.tensor.FloatVector;

@Generated(from="Node2VecModel.Result", generator="Immutables")
public final class ImmutableResult
implements Node2VecModel.Result {
    private final HugeObjectArray<FloatVector> embeddings;
    private final List<Double> lossPerIteration;

    private ImmutableResult(HugeObjectArray<FloatVector> embeddings, Iterable<Double> lossPerIteration) {
        this.embeddings = Objects.requireNonNull(embeddings, "embeddings");
        this.lossPerIteration = ImmutableResult.createUnmodifiableList(false, ImmutableResult.createSafeList(lossPerIteration, true, false));
    }

    private ImmutableResult(ImmutableResult original, HugeObjectArray<FloatVector> embeddings, List<Double> lossPerIteration) {
        this.embeddings = embeddings;
        this.lossPerIteration = lossPerIteration;
    }

    @Override
    public HugeObjectArray<FloatVector> embeddings() {
        return this.embeddings;
    }

    @Override
    public List<Double> lossPerIteration() {
        return this.lossPerIteration;
    }

    public final ImmutableResult withEmbeddings(HugeObjectArray<FloatVector> value) {
        if (this.embeddings == value) {
            return this;
        }
        HugeObjectArray<FloatVector> newValue = Objects.requireNonNull(value, "embeddings");
        return new ImmutableResult(this, newValue, this.lossPerIteration);
    }

    public final ImmutableResult withLossPerIteration(double ... elements) {
        ArrayList<Double> wrappedList = new ArrayList<Double>(elements.length);
        for (double element : elements) {
            wrappedList.add(element);
        }
        List<Double> newValue = ImmutableResult.createUnmodifiableList(false, wrappedList);
        return new ImmutableResult(this, this.embeddings, newValue);
    }

    public final ImmutableResult withLossPerIteration(Iterable<Double> elements) {
        if (this.lossPerIteration == elements) {
            return this;
        }
        List<Double> newValue = ImmutableResult.createUnmodifiableList(false, ImmutableResult.createSafeList(elements, true, false));
        return new ImmutableResult(this, this.embeddings, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.embeddings.equals(another.embeddings) && this.lossPerIteration.equals(another.lossPerIteration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.embeddings.hashCode();
        h += (h << 5) + this.lossPerIteration.hashCode();
        return h;
    }

    public String toString() {
        return "Result{embeddings=" + this.embeddings + ", lossPerIteration=" + this.lossPerIteration + "}";
    }

    public static Node2VecModel.Result of(HugeObjectArray<FloatVector> embeddings, List<Double> lossPerIteration) {
        return ImmutableResult.of(embeddings, lossPerIteration);
    }

    public static Node2VecModel.Result of(HugeObjectArray<FloatVector> embeddings, Iterable<Double> lossPerIteration) {
        return new ImmutableResult(embeddings, lossPerIteration);
    }

    public static Node2VecModel.Result copyOf(Node2VecModel.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Node2VecModel.Result", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMBEDDINGS = 1L;
        private long initBits = 1L;
        private HugeObjectArray<FloatVector> embeddings;
        private List<Double> lossPerIteration = null;

        private Builder() {
        }

        public final Builder from(Node2VecModel.Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.embeddings(instance.embeddings());
            this.addAllLossPerIteration(instance.lossPerIteration());
            return this;
        }

        public final Builder embeddings(HugeObjectArray<FloatVector> embeddings) {
            this.embeddings = Objects.requireNonNull(embeddings, "embeddings");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLossPerIteration(double element) {
            if (this.lossPerIteration == null) {
                this.lossPerIteration = new ArrayList<Double>();
            }
            this.lossPerIteration.add(element);
            return this;
        }

        public final Builder addLossPerIteration(double ... elements) {
            if (this.lossPerIteration == null) {
                this.lossPerIteration = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.lossPerIteration.add(element);
            }
            return this;
        }

        public final Builder lossPerIteration(Iterable<Double> elements) {
            this.lossPerIteration = new ArrayList<Double>();
            return this.addAllLossPerIteration(elements);
        }

        public final Builder addAllLossPerIteration(Iterable<Double> elements) {
            Objects.requireNonNull(elements, "lossPerIteration element");
            if (this.lossPerIteration == null) {
                this.lossPerIteration = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.lossPerIteration.add(Objects.requireNonNull(Double.valueOf(element), "lossPerIteration element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.embeddings = null;
            if (this.lossPerIteration != null) {
                this.lossPerIteration.clear();
            }
            return this;
        }

        public Node2VecModel.Result build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResult(null, this.embeddings, this.lossPerIteration == null ? Collections.emptyList() : ImmutableResult.createUnmodifiableList(true, this.lossPerIteration));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("embeddings");
            }
            return "Cannot build Result, some of required attributes are not set " + attributes;
        }
    }
}

