/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.traversal.RandomWalkAlgorithmFactory;
import org.neo4j.gds.utils.StringFormatting;

public class Node2VecAlgorithmFactory<CONFIG extends Node2VecBaseConfig>
extends GraphAlgorithmFactory<Node2Vec, CONFIG> {
    public String taskName() {
        return "Node2Vec";
    }

    public Node2Vec build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        this.validateConfig(configuration, graph);
        return new Node2Vec(graph, (Node2VecBaseConfig)configuration, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return Node2Vec.memoryEstimation(configuration);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)this.taskName(), (Task)new RandomWalkAlgorithmFactory<CONFIG>().progressTask(graph, config), (Task[])new Task[]{Tasks.iterativeFixed((String)"train", () -> List.of(Tasks.leaf((String)"iteration")), (int)config.iterations())});
    }

    private void validateConfig(CONFIG config, Graph graph) {
        try {
            long l = Math.multiplyExact(Math.multiplyExact(graph.nodeCount(), config.walksPerNode()), config.walkLength());
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Aborting execution, running with the configured parameters is likely to overflow: node count: %d, walks per node: %d, walkLength: %d. Try reducing these parameters or run on a smaller graph.", (Object[])new Object[]{graph.nodeCount(), config.walksPerNode(), config.walkLength()}));
        }
    }
}

