/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface Node2VecBaseConfig
extends AlgoBaseConfig,
EmbeddingDimensionConfig,
RandomWalkBaseConfig {
    @Value.Default
    @Configuration.IntegerRange(min=2)
    default public int windowSize() {
        return 10;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int negativeSamplingRate() {
        return 5;
    }

    @Value.Default
    @Configuration.DoubleRange(min=1.0E-5, minInclusive=false, max=1.0)
    default public double positiveSamplingFactor() {
        return 0.001;
    }

    @Value.Default
    @Configuration.DoubleRange(min=1.0E-5, minInclusive=false, max=1.0)
    default public double negativeSamplingExponent() {
        return 0.75;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int embeddingDimension() {
        return 128;
    }

    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig.EmbeddingInitializer#parse", inverse="__USE_TO_MAP_METHOD__")
    @Configuration.ToMapValue(value="org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig.EmbeddingInitializer#toString")
    default public EmbeddingInitializer embeddingInitializer() {
        return EmbeddingInitializer.NORMALIZED;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double initialLearningRate() {
        return 0.025;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double minLearningRate() {
        return 1.0E-4;
    }

    @Value.Default
    default public int iterations() {
        return 1;
    }

    @Configuration.Ignore
    @Value.Default
    default public List<Long> sourceNodes() {
        return List.of();
    }

    public static enum EmbeddingInitializer {
        UNIFORM,
        NORMALIZED;

        private static final List<String> VALUES;

        public static EmbeddingInitializer parse(Object input) {
            if (input instanceof String) {
                String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
                if (!VALUES.contains(inputString)) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"EmbeddingInitializer `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{input, StringJoining.join(VALUES)}));
                }
                return EmbeddingInitializer.valueOf(StringFormatting.toUpperCaseWithLocale((String)inputString));
            }
            if (input instanceof EmbeddingInitializer) {
                return (EmbeddingInitializer)((Object)input);
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected EmbeddingInitializer or String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
        }

        public static String toString(EmbeddingInitializer embeddingInitializer) {
            return embeddingInitializer.toString();
        }

        static {
            VALUES = Arrays.stream(EmbeddingInitializer.values()).map(Enum::name).collect(Collectors.toList());
        }
    }
}

