/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.embeddings.node2vec.Node2VecWriteConfig;

public final class Node2VecWriteConfigImpl
implements Node2VecWriteConfig {
    private int windowSize;
    private int negativeSamplingRate;
    private double positiveSamplingFactor;
    private double negativeSamplingExponent;
    private int embeddingDimension;
    private Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer;
    private double initialLearningRate;
    private double minLearningRate;
    private int iterations;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private int walkLength;
    private int walksPerNode;
    private int walkBufferSize;
    private double inOutFactor;
    private double returnFactor;
    private Optional<String> relationshipWeightProperty;
    private Optional<Long> randomSeed;
    private String writeProperty;
    private int writeConcurrency;

    public Node2VecWriteConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.windowSize = config.getInt("windowSize", Node2VecWriteConfig.super.windowSize());
            CypherMapAccess.validateIntegerRange((String)"windowSize", (int)this.windowSize, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingRate = config.getInt("negativeSamplingRate", Node2VecWriteConfig.super.negativeSamplingRate());
            CypherMapAccess.validateIntegerRange((String)"negativeSamplingRate", (int)this.negativeSamplingRate, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.positiveSamplingFactor = config.getDouble("positiveSamplingFactor", Node2VecWriteConfig.super.positiveSamplingFactor());
            CypherMapAccess.validateDoubleRange((String)"positiveSamplingFactor", (double)this.positiveSamplingFactor, (double)1.0E-5, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingExponent = config.getDouble("negativeSamplingExponent", Node2VecWriteConfig.super.negativeSamplingExponent());
            CypherMapAccess.validateDoubleRange((String)"negativeSamplingExponent", (double)this.negativeSamplingExponent, (double)1.0E-5, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.embeddingDimension = config.getInt("embeddingDimension", Node2VecWriteConfig.super.embeddingDimension());
            CypherMapAccess.validateIntegerRange((String)"embeddingDimension", (int)this.embeddingDimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.embeddingInitializer = (Node2VecBaseConfig.EmbeddingInitializer)((Object)CypherMapAccess.failOnNull((String)"embeddingInitializer", (Object)((Object)Node2VecBaseConfig.EmbeddingInitializer.parse(config.getChecked("embeddingInitializer", (Object)Node2VecWriteConfig.super.embeddingInitializer(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.initialLearningRate = config.getDouble("initialLearningRate", Node2VecWriteConfig.super.initialLearningRate());
            CypherMapAccess.validateDoubleRange((String)"initialLearningRate", (double)this.initialLearningRate, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minLearningRate = config.getDouble("minLearningRate", Node2VecWriteConfig.super.minLearningRate());
            CypherMapAccess.validateDoubleRange((String)"minLearningRate", (double)this.minLearningRate, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.iterations = config.getInt("iterations", Node2VecWriteConfig.super.iterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)Node2VecWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)Node2VecWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", Node2VecWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", Node2VecWriteConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", Node2VecWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)Node2VecWriteConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.walkLength = config.getInt("walkLength", Node2VecWriteConfig.super.walkLength());
            CypherMapAccess.validateIntegerRange((String)"walkLength", (int)this.walkLength, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.walksPerNode = config.getInt("walksPerNode", Node2VecWriteConfig.super.walksPerNode());
            CypherMapAccess.validateIntegerRange((String)"walksPerNode", (int)this.walksPerNode, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.walkBufferSize = config.getInt("walkBufferSize", Node2VecWriteConfig.super.walkBufferSize());
            CypherMapAccess.validateIntegerRange((String)"walkBufferSize", (int)this.walkBufferSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.inOutFactor = config.getDouble("inOutFactor", Node2VecWriteConfig.super.inOutFactor());
            CypherMapAccess.validateDoubleRange((String)"inOutFactor", (double)this.inOutFactor, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.returnFactor = config.getDouble("returnFactor", Node2VecWriteConfig.super.returnFactor());
            CypherMapAccess.validateDoubleRange((String)"returnFactor", (double)this.returnFactor, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapAccess.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", Node2VecWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int windowSize() {
        return this.windowSize;
    }

    @Override
    public int negativeSamplingRate() {
        return this.negativeSamplingRate;
    }

    @Override
    public double positiveSamplingFactor() {
        return this.positiveSamplingFactor;
    }

    @Override
    public double negativeSamplingExponent() {
        return this.negativeSamplingExponent;
    }

    @Override
    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    @Override
    public Node2VecBaseConfig.EmbeddingInitializer embeddingInitializer() {
        return this.embeddingInitializer;
    }

    @Override
    public double initialLearningRate() {
        return this.initialLearningRate;
    }

    @Override
    public double minLearningRate() {
        return this.minLearningRate;
    }

    @Override
    public int iterations() {
        return this.iterations;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateSourceLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateGraphIsSuitableForWrite(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("windowSize", "negativeSamplingRate", "positiveSamplingFactor", "negativeSamplingExponent", "embeddingDimension", "embeddingInitializer", "initialLearningRate", "minLearningRate", "iterations", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "walkLength", "walksPerNode", "walkBufferSize", "inOutFactor", "returnFactor", "relationshipWeightProperty", "randomSeed", "writeProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("windowSize", this.windowSize());
        map.put("negativeSamplingRate", this.negativeSamplingRate());
        map.put("positiveSamplingFactor", this.positiveSamplingFactor());
        map.put("negativeSamplingExponent", this.negativeSamplingExponent());
        map.put("embeddingDimension", this.embeddingDimension());
        map.put("embeddingInitializer", Node2VecBaseConfig.EmbeddingInitializer.toString(this.embeddingInitializer()));
        map.put("initialLearningRate", this.initialLearningRate());
        map.put("minLearningRate", this.minLearningRate());
        map.put("iterations", this.iterations());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("walkLength", this.walkLength());
        map.put("walksPerNode", this.walksPerNode());
        map.put("walkBufferSize", this.walkBufferSize());
        map.put("inOutFactor", this.inOutFactor());
        map.put("returnFactor", this.returnFactor());
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    @Override
    public int walkLength() {
        return this.walkLength;
    }

    @Override
    public int walksPerNode() {
        return this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        return this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        return this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        return this.returnFactor;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(Node2VecWriteConfig baseConfig) {
            Builder builder = new Builder();
            builder.windowSize(baseConfig.windowSize());
            builder.negativeSamplingRate(baseConfig.negativeSamplingRate());
            builder.positiveSamplingFactor(baseConfig.positiveSamplingFactor());
            builder.negativeSamplingExponent(baseConfig.negativeSamplingExponent());
            builder.embeddingDimension(baseConfig.embeddingDimension());
            builder.embeddingInitializer(Node2VecBaseConfig.EmbeddingInitializer.toString(baseConfig.embeddingInitializer()));
            builder.initialLearningRate(baseConfig.initialLearningRate());
            builder.minLearningRate(baseConfig.minLearningRate());
            builder.iterations(baseConfig.iterations());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.walkLength(baseConfig.walkLength());
            builder.walksPerNode(baseConfig.walksPerNode());
            builder.walkBufferSize(baseConfig.walkBufferSize());
            builder.inOutFactor(baseConfig.inOutFactor());
            builder.returnFactor(baseConfig.returnFactor());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.randomSeed(baseConfig.randomSeed());
            builder.writeProperty(baseConfig.writeProperty());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            return builder;
        }

        public Builder windowSize(int windowSize) {
            this.config.put("windowSize", windowSize);
            return this;
        }

        public Builder negativeSamplingRate(int negativeSamplingRate) {
            this.config.put("negativeSamplingRate", negativeSamplingRate);
            return this;
        }

        public Builder positiveSamplingFactor(double positiveSamplingFactor) {
            this.config.put("positiveSamplingFactor", positiveSamplingFactor);
            return this;
        }

        public Builder negativeSamplingExponent(double negativeSamplingExponent) {
            this.config.put("negativeSamplingExponent", negativeSamplingExponent);
            return this;
        }

        public Builder embeddingDimension(int embeddingDimension) {
            this.config.put("embeddingDimension", embeddingDimension);
            return this;
        }

        public Builder embeddingInitializer(Object embeddingInitializer) {
            this.config.put("embeddingInitializer", embeddingInitializer);
            return this;
        }

        public Builder initialLearningRate(double initialLearningRate) {
            this.config.put("initialLearningRate", initialLearningRate);
            return this;
        }

        public Builder minLearningRate(double minLearningRate) {
            this.config.put("minLearningRate", minLearningRate);
            return this;
        }

        public Builder iterations(int iterations) {
            this.config.put("iterations", iterations);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder walkLength(int walkLength) {
            this.config.put("walkLength", walkLength);
            return this;
        }

        public Builder walksPerNode(int walksPerNode) {
            this.config.put("walksPerNode", walksPerNode);
            return this;
        }

        public Builder walkBufferSize(int walkBufferSize) {
            this.config.put("walkBufferSize", walkBufferSize);
            return this;
        }

        public Builder inOutFactor(double inOutFactor) {
            this.config.put("inOutFactor", inOutFactor);
            return this;
        }

        public Builder returnFactor(double returnFactor) {
            this.config.put("returnFactor", returnFactor);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Node2VecWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new Node2VecWriteConfigImpl((CypherMapAccess)config);
        }
    }
}

