/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.influenceMaximization.ICInitTask;
import org.neo4j.gds.influenceMaximization.ICLazyForwardMC;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationResult;

public class CELF
extends Algorithm<LongDoubleScatterMap> {
    private final long seedSetCount;
    private final double propagationProbability;
    private final int monteCarloSimulations;
    private final int concurrency;
    private final Graph graph;
    private final long initialRandomSeed;
    private final int batchSize;
    private final LongDoubleScatterMap seedSetNodes;
    private final HugeLongPriorityQueue spreads;
    private final ExecutorService executorService;
    private double gain;

    public CELF(Graph graph, int seedSetCount, double propagationProbability, int monteCarloSimulations, ExecutorService executorService, int concurrency, long initialRandomSeed, int batchSize, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.initialRandomSeed = initialRandomSeed;
        this.batchSize = batchSize;
        long nodeCount = graph.nodeCount();
        this.seedSetCount = (long)seedSetCount <= nodeCount ? (long)seedSetCount : nodeCount;
        this.propagationProbability = propagationProbability;
        this.monteCarloSimulations = monteCarloSimulations;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.seedSetNodes = new LongDoubleScatterMap(seedSetCount);
        this.spreads = new HugeLongPriorityQueue(nodeCount){

            protected boolean lessThan(long a, long b) {
                return Double.compare(this.costValues.get(a), this.costValues.get(b)) == 0 ? a < b : this.costValues.get(a) > this.costValues.get(b);
            }
        };
    }

    public LongDoubleScatterMap compute() {
        this.progressTracker.beginSubTask();
        long firstSeedNode = this.greedyPart();
        this.lazyForwardPart(firstSeedNode);
        this.progressTracker.endSubTask();
        return this.seedSetNodes;
    }

    private long greedyPart() {
        HugeDoubleArray singleSpreadArray = HugeDoubleArray.newArray((long)this.graph.nodeCount());
        this.progressTracker.beginSubTask(this.graph.nodeCount());
        List tasks = PartitionUtils.rangePartition((int)this.concurrency, (long)this.graph.nodeCount(), partition -> new ICInitTask((Partition)partition, this.graph, this.propagationProbability, this.monteCarloSimulations, singleSpreadArray, this.initialRandomSeed, this.progressTracker), Optional.of(Math.toIntExact(this.graph.nodeCount()) / this.concurrency));
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)tasks).executor(this.executorService).run();
        this.progressTracker.endSubTask();
        this.graph.forEachNode(nodeId -> {
            this.spreads.add(nodeId, singleSpreadArray.get(nodeId));
            return true;
        });
        long highestNode = this.spreads.top();
        this.gain = this.spreads.cost(highestNode);
        this.spreads.pop();
        this.seedSetNodes.put(highestNode, this.gain);
        return highestNode;
    }

    private void lazyForwardPart(long firstSeedNode) {
        ICLazyForwardMC independentCascade = ICLazyForwardMC.create(this.graph, this.propagationProbability, this.monteCarloSimulations, firstSeedNode, (int)this.seedSetCount, this.concurrency, this.executorService, this.initialRandomSeed, this.batchSize);
        this.progressTracker.beginSubTask(this.seedSetCount - 1L);
        HugeIntArray lastUpdate = HugeIntArray.newArray((long)this.graph.nodeCount());
        long[] firstK = new long[this.batchSize];
        int i = 1;
        while ((long)i < this.seedSetCount) {
            while (lastUpdate.get(this.spreads.top()) != i) {
                long batchUpperBound = Math.min((long)this.batchSize, this.spreads.size());
                int actualBatchSize = 0;
                int j = 0;
                while ((long)j < batchUpperBound) {
                    long nextNodeId = this.spreads.getIth(j);
                    if (lastUpdate.get(nextNodeId) != i) {
                        firstK[actualBatchSize++] = nextNodeId;
                    }
                    ++j;
                }
                independentCascade.runForCandidate(firstK, actualBatchSize);
                for (j = 0; j < actualBatchSize; ++j) {
                    long nodeId = firstK[j];
                    double value = independentCascade.getSpread(j) / (double)this.monteCarloSimulations;
                    this.spreads.set(nodeId, value - this.gain);
                    lastUpdate.set(nodeId, i);
                }
            }
            double highestScore = this.spreads.cost(this.spreads.top());
            long highestNode = this.spreads.pop();
            this.seedSetNodes.put(highestNode, highestScore);
            this.gain += highestScore;
            independentCascade.incrementSeedNode(highestNode);
            this.progressTracker.logProgress();
            ++i;
        }
        this.progressTracker.endSubTask();
    }

    public void release() {
    }

    public Stream<InfluenceMaximizationResult> resultStream() {
        return LongStream.of(this.seedSetNodes.keys().toArray()).mapToObj(node -> new InfluenceMaximizationResult(this.graph.toOriginalNodeId(node), this.seedSetNodes.getOrDefault(node, 0.0)));
    }
}

