/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.ICLazyForwardTask;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.mem.MemoryUsage;

public class CELFAlgorithmFactory<CONFIG extends InfluenceMaximizationBaseConfig>
extends GraphAlgorithmFactory<CELF, CONFIG> {
    public static final int DEFAULT_BATCH_SIZE = 10;

    public String taskName() {
        return "CELF";
    }

    public CELF build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return new CELF(graph, configuration.seedSetSize(), configuration.propagationProbability(), configuration.monteCarloSimulations(), Pools.DEFAULT, configuration.concurrency(), configuration.randomSeed().orElse(0L), 10, progressTracker);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)"CELF", (Task)Tasks.leaf((String)"Greedy", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"LazyForwarding", (long)(config.seedSetSize() - 1))});
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(CELF.class);
        builder.fixed("seedSet", MemoryUsage.sizeOfLongDoubleScatterMap((long)configuration.seedSetSize())).fixed("firstK", MemoryUsage.sizeOfLongArray((long)10L)).add("LazyForwarding: spread priority queue", HugeLongPriorityQueue.memoryEstimation()).perNode("greedy part: single spread array: ", HugeDoubleArray::memoryEstimation);
        builder.perThread("ICInit", this.ICInitMemoryEstimationBuilder().build());
        builder.fixed("spread", MemoryUsage.sizeOfDoubleArray((long)10L));
        builder.add("newActive", this.ICLazyMemoryEstimationBuilder(configuration).build());
        return builder.build();
    }

    private MemoryEstimations.Builder ICInitMemoryEstimationBuilder() {
        return MemoryEstimations.builder(ICLazyForwardTask.class).perNode("active", MemoryUsage::sizeOfBitset).add("newActive", HugeLongArrayStack.memoryEstimation());
    }

    private MemoryEstimations.Builder ICLazyMemoryEstimationBuilder(CONFIG configuration) {
        return MemoryEstimations.builder(ICLazyForwardTask.class).perNode("seedActive", MemoryUsage::sizeOfBitset).perNode("candidateActive", MemoryUsage::sizeOfBitset).fixed("localSpread", MemoryRange.of((long)MemoryUsage.sizeOfDoubleArray((long)10L))).fixed("candidateNodeIds", MemoryRange.of((long)MemoryUsage.sizeOfLongArray((long)10L))).fixed("seedSetNodeIds", MemoryRange.of((long)MemoryUsage.sizeOfLongArray((long)configuration.seedSetSize()))).add("newActive", HugeLongArrayStack.memoryEstimation());
    }
}

