/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.BitSet;
import java.util.SplittableRandom;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

final class ICInitTask
implements Runnable {
    private final Graph localGraph;
    private final double propagationProbability;
    private final int monteCarloSimulations;
    private final HugeDoubleArray singleSpreadArray;
    private final Partition partition;
    private final BitSet active;
    private final HugeLongArrayStack newActive;
    private final long initialRandomSeed;
    private final ProgressTracker progressTracker;

    ICInitTask(Partition partition, Graph graph, double propagationProbability, int monteCarloSimulations, HugeDoubleArray singleSpreadArray, long initialRandomSeed, ProgressTracker progressTracker) {
        this.partition = partition;
        this.localGraph = graph.concurrentCopy();
        this.propagationProbability = propagationProbability;
        this.monteCarloSimulations = monteCarloSimulations;
        this.singleSpreadArray = singleSpreadArray;
        this.progressTracker = progressTracker;
        this.active = new BitSet(graph.nodeCount());
        this.newActive = HugeLongArrayStack.newStack((long)graph.nodeCount());
        this.initialRandomSeed = initialRandomSeed;
    }

    private void initDataStructures(long candidateNodeId) {
        this.active.clear();
        this.newActive.push(candidateNodeId);
        this.active.set(candidateNodeId);
    }

    @Override
    public void run() {
        long startNode = this.partition.startNode();
        long endNode = startNode + this.partition.nodeCount();
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            double nodeSpread = 0.0;
            for (int simulation = 0; simulation < this.monteCarloSimulations; ++simulation) {
                this.initDataStructures(nodeId);
                while (!this.newActive.isEmpty()) {
                    long nextExaminedNode = this.newActive.pop();
                    SplittableRandom rand = new SplittableRandom(this.initialRandomSeed + (long)simulation);
                    this.localGraph.forEachRelationship(nextExaminedNode, (source, target) -> {
                        if (rand.nextDouble() < this.propagationProbability && !this.active.get(target)) {
                            this.newActive.push(target);
                            this.active.set(target);
                        }
                        return true;
                    });
                }
                nodeSpread += (double)this.active.cardinality();
            }
            this.singleSpreadArray.set(nodeId, nodeSpread / (double)this.monteCarloSimulations);
            this.progressTracker.logProgress();
        }
    }
}

