/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.influenceMaximization.ICLazyForwardTask;

final class ICLazyForwardMC {
    private final int concurrency;
    private final List<ICLazyForwardTask> tasks;
    private final ExecutorService executorService;
    private final double[] spread;

    static ICLazyForwardMC create(Graph graph, double propagationProbability, int monteCarloSimulations, long firstNodeInSeedSet, int seedSetCount, int concurrency, ExecutorService executorService, long initialRandomSeed, int batchSize) {
        double[] spread = new double[batchSize];
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)monteCarloSimulations, partition -> new ICLazyForwardTask((Partition)partition, graph.concurrentCopy(), firstNodeInSeedSet, seedSetCount, propagationProbability, initialRandomSeed, batchSize), Optional.of(monteCarloSimulations / concurrency));
        return new ICLazyForwardMC(tasks, concurrency, executorService, spread);
    }

    private ICLazyForwardMC(List<ICLazyForwardTask> tasks, int concurrency, ExecutorService executorService, double[] spread) {
        this.tasks = tasks;
        this.spread = spread;
        this.concurrency = concurrency;
        this.executorService = executorService;
    }

    void runForCandidate(long[] candidateIdNodes, int candidateSize) {
        for (ICLazyForwardTask task : this.tasks) {
            task.setCandidateNodeId(candidateIdNodes, candidateSize);
        }
        for (int j = 0; j < candidateSize; ++j) {
            this.spread[j] = 0.0;
        }
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(this.tasks).executor(this.executorService).run();
        for (ICLazyForwardTask task : this.tasks) {
            for (int j = 0; j < candidateSize; ++j) {
                int n = j;
                this.spread[n] = this.spread[n] + task.getSpread(j);
            }
        }
    }

    double getSpread(int j) {
        return this.spread[j];
    }

    void incrementSeedNode(long newSetNode) {
        for (ICLazyForwardTask task : this.tasks) {
            task.incrementSeedNode(newSetNode);
        }
    }
}

