/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.BitSet;
import java.util.SplittableRandom;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.partition.Partition;

final class ICLazyForwardTask
implements Runnable {
    private final long[] seedSetNodes;
    private final long initialRandomSeed;
    private int seedNodeCounter;
    private final Partition partition;
    private final long[] candidateNodeIds;
    private int candidateSetSizes;
    private final double[] localSpread;
    private final Graph localGraph;
    private final BitSet candidateActive;
    private final BitSet seedActive;
    private final HugeLongArrayStack newActive;
    private final double propagationProbability;

    ICLazyForwardTask(Partition partition, Graph graph, long firstNodeInSeedSet, int seedSetCount, double propagationProbability, long initialRandomSeed, int batchSize) {
        this.localGraph = graph;
        this.newActive = HugeLongArrayStack.newStack((long)graph.nodeCount());
        this.seedActive = new BitSet(graph.nodeCount());
        this.candidateActive = new BitSet(graph.nodeCount());
        this.propagationProbability = propagationProbability;
        this.seedSetNodes = new long[seedSetCount];
        this.seedSetNodes[0] = firstNodeInSeedSet;
        this.initialRandomSeed = initialRandomSeed;
        this.seedNodeCounter = 1;
        this.partition = partition;
        this.localSpread = new double[batchSize];
        this.candidateNodeIds = new long[batchSize];
    }

    void incrementSeedNode(long newSetNode) {
        this.seedSetNodes[this.seedNodeCounter++] = newSetNode;
    }

    void setCandidateNodeId(long[] candidateNodeIds, int candidateSetSize) {
        if (candidateSetSize >= 0) {
            System.arraycopy(candidateNodeIds, 0, this.candidateNodeIds, 0, candidateSetSize);
        }
        this.candidateSetSizes = candidateSetSize;
    }

    double getSpread(int j) {
        return this.localSpread[j];
    }

    private void initCandidate(long candidateId) {
        if (!this.seedActive.get(candidateId)) {
            this.candidateActive.clear();
            this.candidateActive.set(candidateId);
            this.newActive.push(candidateId);
        }
    }

    private void initDataStructures() {
        this.seedActive.clear();
        for (int i = 0; i < this.seedNodeCounter; ++i) {
            this.newActive.push(this.seedSetNodes[i]);
            this.seedActive.set(this.seedSetNodes[i]);
        }
    }

    private void seedTraverse(long seed) {
        while (!this.newActive.isEmpty()) {
            long nodeId = this.newActive.pop();
            SplittableRandom rand = new SplittableRandom(this.initialRandomSeed + seed);
            this.localGraph.forEachRelationship(nodeId, (source, target) -> {
                if (rand.nextDouble() < this.propagationProbability && !this.seedActive.get(target)) {
                    this.newActive.push(target);
                    this.seedActive.set(target);
                }
                return true;
            });
        }
    }

    private void candidateTraverse(long seed) {
        while (!this.newActive.isEmpty()) {
            long nodeId = this.newActive.pop();
            SplittableRandom rand = new SplittableRandom(this.initialRandomSeed + seed);
            this.localGraph.forEachRelationship(nodeId, (source, target) -> {
                if (rand.nextDouble() < this.propagationProbability && !this.seedActive.get(target) && !this.candidateActive.get(target)) {
                    this.newActive.push(target);
                    this.candidateActive.set(target);
                }
                return true;
            });
        }
    }

    @Override
    public void run() {
        for (int j = 0; j < this.candidateSetSizes; ++j) {
            this.localSpread[j] = 0.0;
        }
        long startingSeed = this.partition.startNode();
        long endingSeed = this.partition.nodeCount() + startingSeed;
        for (long seed = startingSeed; seed < endingSeed; ++seed) {
            this.initDataStructures();
            this.seedTraverse(seed);
            for (int j = 0; j < this.candidateSetSizes; ++j) {
                this.initCandidate(this.candidateNodeIds[j]);
                int n = j;
                this.localSpread[n] = this.localSpread[n] + (double)this.seedActive.cardinality();
                if (this.newActive.isEmpty()) continue;
                this.candidateTraverse(seed);
                int n2 = j;
                this.localSpread[n2] = this.localSpread[n2] + (double)this.candidateActive.cardinality();
            }
        }
    }
}

