/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongScatterSet;
import java.util.SplittableRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;

final class IndependentCascade {
    private static final Lock lock = new ReentrantLock();
    private final Graph graph;
    private final double propagationProbability;
    private final long monteCarloSimulations;
    private final HugeLongPriorityQueue spreads;
    private final LongScatterSet active;
    private final HugeLongArrayStack newActive;
    private double spread;

    IndependentCascade(Graph graph, double propagationProbability, long monteCarloSimulations, HugeLongPriorityQueue spreads) {
        this.graph = graph.concurrentCopy();
        this.propagationProbability = propagationProbability;
        this.monteCarloSimulations = monteCarloSimulations;
        this.spreads = spreads;
        this.active = new LongScatterSet();
        this.newActive = HugeLongArrayStack.newStack((long)graph.nodeCount());
    }

    public void run(long candidateNode, long[] seedSetNodes) {
        this.spread = 0.0;
        for (long i = 0L; i < this.monteCarloSimulations; ++i) {
            this.initStructures(candidateNode, seedSetNodes);
            this.spread += (double)this.newActive.size();
            while (!this.newActive.isEmpty()) {
                SplittableRandom rand = new SplittableRandom(i);
                long node = this.newActive.pop();
                this.graph.forEachRelationship(node, (source, target) -> {
                    if (rand.nextDouble() < this.propagationProbability && !this.active.contains(target)) {
                        this.spread += 1.0;
                        this.newActive.push(target);
                        this.active.add(target);
                    }
                    return true;
                });
            }
        }
        this.spread /= (double)this.monteCarloSimulations;
        this.addCandidateNode(candidateNode);
    }

    private void addCandidateNode(long candidateNode) {
        try {
            lock.lock();
            this.spreads.add(candidateNode, (double)Math.round(this.spread * 1000.0) / 1000.0);
        }
        finally {
            lock.unlock();
        }
    }

    private void initStructures(long candidateNode, long[] seedSetNodes) {
        this.active.clear();
        this.active.add(candidateNode);
        this.active.addAll(seedSetNodes);
        this.newActive.push(candidateNode);
        for (long kNode : seedSetNodes) {
            this.newActive.push(kNode);
        }
    }
}

