/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.collections.ArrayUtil;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.influenceMaximization.IndependentCascade;

class IndependentCascadeRunner
implements Runnable {
    private final Graph graph;
    private final HugeLongPriorityQueue spreads;
    private final AtomicLong globalNodeProgress;
    private final double propagationProbability;
    private final int monteCarloSimulations;
    private long[] seedSetNodes;

    IndependentCascadeRunner(Graph graph, HugeLongPriorityQueue spreads, AtomicLong globalNodeProgress, double propagationProbability, int monteCarloSimulations) {
        this.graph = graph;
        this.spreads = spreads;
        this.globalNodeProgress = globalNodeProgress;
        this.propagationProbability = propagationProbability;
        this.monteCarloSimulations = monteCarloSimulations;
    }

    void setSeedSetNodes(long[] seedSetNodes) {
        this.seedSetNodes = seedSetNodes;
    }

    @Override
    public void run() {
        IndependentCascade independentCascade = new IndependentCascade(this.graph, this.propagationProbability, this.monteCarloSimulations, this.spreads);
        long candidateNode = 0L;
        while ((candidateNode = this.globalNodeProgress.getAndIncrement()) < this.graph.nodeCount()) {
            if (ArrayUtil.contains((long[])this.seedSetNodes, (long)candidateNode)) continue;
            independentCascade.run(candidateNode, this.seedSetNodes);
        }
    }
}

