/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.List;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.kmeans.DoubleClusterManager;
import org.neo4j.gds.kmeans.FloatClusterManager;
import org.neo4j.gds.kmeans.KmeansTask;
import org.neo4j.gds.mem.MemoryUsage;

abstract class ClusterManager {
    final long[] nodesInCluster;
    final boolean[] shouldReset;
    final NodePropertyValues nodePropertyValues;
    final int dimensions;
    final int k;
    int currentlyAssigned;

    ClusterManager(NodePropertyValues values, int dimensions, int k) {
        this.dimensions = dimensions;
        this.k = k;
        this.nodePropertyValues = values;
        this.nodesInCluster = new long[k];
        this.currentlyAssigned = 0;
        this.shouldReset = new boolean[k];
    }

    int getCurrentlyAssigned() {
        return this.currentlyAssigned;
    }

    abstract void initialAssignCluster(long var1);

    void reset() {
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            this.nodesInCluster[centroidId] = 0L;
            this.shouldReset[centroidId] = true;
        }
    }

    abstract void normalizeClusters();

    abstract void updateFromTask(KmeansTask var1);

    void initializeCentroids(List<Long> initialCentroidIds) {
        this.currentlyAssigned = 0;
        for (Long currentId : initialCentroidIds) {
            this.initialAssignCluster(currentId);
        }
    }

    abstract double[][] getCentroids();

    public long[] getNodesInCluster() {
        return this.nodesInCluster;
    }

    static ClusterManager createClusterManager(NodePropertyValues values, int dimensions, int k) {
        if (values.valueType() == ValueType.FLOAT_ARRAY) {
            return new FloatClusterManager(values, dimensions, k);
        }
        return new DoubleClusterManager(values, dimensions, k);
    }

    public abstract double euclidean(long var1, int var3);

    public int findClosestCentroid(long nodeId) {
        int community = 0;
        double smallestDistance = Double.MAX_VALUE;
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            double distance = this.euclidean(nodeId, centroidId);
            if (Double.compare(distance, smallestDistance) >= 0) continue;
            smallestDistance = distance;
            community = centroidId;
        }
        return community;
    }

    static MemoryEstimation memoryEstimation(int k, int fakeDimensions) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(ClusterManager.class);
        builder.fixed("nodesInCluster", MemoryUsage.sizeOfLongArray((long)k)).fixed("shouldReset", MemoryUsage.sizeOfArray((long)k, (long)1L)).add("centroidsSize", MemoryEstimations.of((String)"centroidsSize", (MemoryRange)MemoryRange.of((long)MemoryUsage.sizeOfFloatArray((long)fakeDimensions), (long)MemoryUsage.sizeOfDoubleArray((long)fakeDimensions))));
        return builder.build();
    }

    public abstract void assignSeededCentroids(List<List<Double>> var1);
}

