/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.Arrays;
import java.util.List;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.Intersections;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.DoubleKmeansTask;
import org.neo4j.gds.kmeans.KmeansTask;

class DoubleClusterManager
extends ClusterManager {
    private final double[][] centroids;

    DoubleClusterManager(NodePropertyValues values, int dimensions, int k) {
        super(values, dimensions, k);
        this.centroids = new double[k][dimensions];
    }

    @Override
    public void normalizeClusters() {
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            for (int dimension = 0; dimension < this.dimensions; ++dimension) {
                if (this.nodesInCluster[centroidId] <= 0L) continue;
                double[] dArray = this.centroids[centroidId];
                int n = dimension;
                dArray[n] = dArray[n] / (double)this.nodesInCluster[centroidId];
            }
        }
    }

    @Override
    public void updateFromTask(KmeansTask task) {
        DoubleKmeansTask doubleKmeansTask = (DoubleKmeansTask)task;
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            long contribution = task.getNumAssignedAtCluster(centroidId);
            if (contribution <= 0L) continue;
            if (this.shouldReset[centroidId]) {
                Arrays.fill(this.centroids[centroidId], 0.0);
                this.shouldReset[centroidId] = false;
            }
            int n = centroidId;
            this.nodesInCluster[n] = this.nodesInCluster[n] + contribution;
            double[] taskContributionToCluster = doubleKmeansTask.getCentroidContribution(centroidId);
            for (int dimension = 0; dimension < this.dimensions; ++dimension) {
                double[] dArray = this.centroids[centroidId];
                int n2 = dimension;
                dArray[n2] = dArray[n2] + taskContributionToCluster[dimension];
            }
        }
    }

    @Override
    public double euclidean(long nodeId, int centroidId) {
        double[] left = this.nodePropertyValues.doubleArrayValue(nodeId);
        double[] right = this.centroids[centroidId];
        return Math.sqrt(Intersections.sumSquareDelta((double[])left, (double[])right, (int)right.length));
    }

    @Override
    public void initialAssignCluster(long id) {
        double[] cluster = this.nodePropertyValues.doubleArrayValue(id);
        System.arraycopy(cluster, 0, this.centroids[this.currentlyAssigned++], 0, cluster.length);
    }

    @Override
    public double[][] getCentroids() {
        return this.centroids;
    }

    @Override
    public void assignSeededCentroids(List<List<Double>> seededCentroids) {
        for (List<Double> centroid : seededCentroids) {
            double[] centroidArray = new double[this.dimensions];
            int index = 0;
            for (double value : centroid) {
                centroidArray[index++] = value;
            }
            System.arraycopy(centroidArray, 0, this.centroids[this.currentlyAssigned++], 0, centroidArray.length);
        }
    }
}

