/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.Intersections;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.SilhouetteTask;

class DoubleSilhouetteTask
extends SilhouetteTask {
    DoubleSilhouetteTask(NodePropertyValues nodePropertyValues, HugeIntArray communities, HugeDoubleArray silhouette, int k, int dimensions, long[] nodesInCluster, Partition partition, ProgressTracker progressTracker) {
        super(nodePropertyValues, communities, silhouette, k, dimensions, nodesInCluster, partition, progressTracker);
    }

    @Override
    double distance(long nodeA, long nodeB) {
        double[] left = this.nodePropertyValues.doubleArrayValue(nodeA);
        double[] right = this.nodePropertyValues.doubleArrayValue(nodeB);
        return Math.sqrt(Intersections.sumSquareDelta((double[])left, (double[])right, (int)right.length));
    }
}

