/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.Arrays;
import java.util.List;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.Intersections;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.FloatKmeansTask;
import org.neo4j.gds.kmeans.KmeansTask;

class FloatClusterManager
extends ClusterManager {
    private final float[][] centroids;

    FloatClusterManager(NodePropertyValues values, int dimensions, int k) {
        super(values, dimensions, k);
        this.centroids = new float[k][dimensions];
    }

    @Override
    public void normalizeClusters() {
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            for (int dimension = 0; dimension < this.dimensions; ++dimension) {
                if (this.nodesInCluster[centroidId] <= 0L) continue;
                float[] fArray = this.centroids[centroidId];
                int n = dimension;
                fArray[n] = fArray[n] / (float)this.nodesInCluster[centroidId];
            }
        }
    }

    @Override
    public void initialAssignCluster(long id) {
        float[] cluster = this.nodePropertyValues.floatArrayValue(id);
        System.arraycopy(cluster, 0, this.centroids[this.currentlyAssigned++], 0, cluster.length);
    }

    @Override
    public void updateFromTask(KmeansTask task) {
        FloatKmeansTask floatKmeansTask = (FloatKmeansTask)task;
        for (int centroidId = 0; centroidId < this.k; ++centroidId) {
            long contribution = task.getNumAssignedAtCluster(centroidId);
            if (contribution <= 0L) continue;
            if (this.shouldReset[centroidId]) {
                Arrays.fill(this.centroids[centroidId], 0.0f);
                this.shouldReset[centroidId] = false;
            }
            int n = centroidId;
            this.nodesInCluster[n] = this.nodesInCluster[n] + contribution;
            float[] taskContributionToCluster = floatKmeansTask.getCentroidContribution(centroidId);
            for (int dimension = 0; dimension < this.dimensions; ++dimension) {
                float[] fArray = this.centroids[centroidId];
                int n2 = dimension;
                fArray[n2] = fArray[n2] + taskContributionToCluster[dimension];
            }
        }
    }

    @Override
    double[][] getCentroids() {
        double[][] doubleCentroids = new double[this.k][this.dimensions];
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.dimensions; ++j) {
                doubleCentroids[i][j] = this.centroids[i][j];
            }
        }
        return doubleCentroids;
    }

    @Override
    public double euclidean(long nodeId, int centroidId) {
        float[] left = this.nodePropertyValues.floatArrayValue(nodeId);
        float[] right = this.centroids[centroidId];
        return Math.sqrt(Intersections.sumSquareDelta((float[])left, (float[])right, (int)right.length));
    }

    @Override
    public void assignSeededCentroids(List<List<Double>> seededCentroids) {
        for (List<Double> centroid : seededCentroids) {
            float[] centroidArray = new float[this.dimensions];
            int index = 0;
            for (double value : centroid) {
                centroidArray[index++] = (float)value;
            }
            System.arraycopy(centroidArray, 0, this.centroids[this.currentlyAssigned++], 0, centroidArray.length);
        }
    }
}

