/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.Arrays;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.KmeansSampler;
import org.neo4j.gds.kmeans.KmeansTask;

final class FloatKmeansTask
extends KmeansTask {
    private final float[][] communityCoordinateSums;

    FloatKmeansTask(KmeansSampler.SamplerType samplerType, ClusterManager clusterManager, NodePropertyValues nodePropertyValues, HugeIntArray communities, HugeDoubleArray distanceFromCluster, int k, int dimensions, Partition partition) {
        super(samplerType, clusterManager, nodePropertyValues, communities, distanceFromCluster, k, dimensions, partition);
        this.communityCoordinateSums = new float[k][dimensions];
    }

    float[] getCentroidContribution(int ith) {
        return this.communityCoordinateSums[ith];
    }

    @Override
    void reset() {
        for (int community = 0; community < this.k; ++community) {
            this.communitySizes[community] = 0L;
            Arrays.fill(this.communityCoordinateSums[community], 0.0f);
        }
    }

    @Override
    void updateAfterAssignmentToCentroid(long nodeId, int community) {
        float[] property = this.nodePropertyValues.floatArrayValue(nodeId);
        this.communities.set(nodeId, community);
        for (int j = 0; j < this.dimensions; ++j) {
            float[] fArray = this.communityCoordinateSums[community];
            int n = j;
            fArray[n] = fArray[n] + property[j];
        }
    }
}

