/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.KmeansContext;

@Generated(from="KmeansContext", generator="Immutables")
public final class ImmutableKmeansContext
implements KmeansContext {
    private final ExecutorService executor;
    private final ProgressTracker progressTracker;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKmeansContext(ExecutorService executor, ProgressTracker progressTracker) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
        this.initShim = null;
    }

    private ImmutableKmeansContext(Builder builder) {
        if (builder.executor != null) {
            this.initShim.executor(builder.executor);
        }
        if (builder.progressTracker != null) {
            this.initShim.progressTracker(builder.progressTracker);
        }
        this.executor = this.initShim.executor();
        this.progressTracker = this.initShim.progressTracker();
        this.initShim = null;
    }

    private ImmutableKmeansContext(ImmutableKmeansContext original, ExecutorService executor, ProgressTracker progressTracker) {
        this.executor = executor;
        this.progressTracker = progressTracker;
        this.initShim = null;
    }

    private ExecutorService executorInitialize() {
        return KmeansContext.super.executor();
    }

    private ProgressTracker progressTrackerInitialize() {
        return KmeansContext.super.progressTracker();
    }

    @Override
    public ExecutorService executor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executor() : this.executor;
    }

    @Override
    public ProgressTracker progressTracker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressTracker() : this.progressTracker;
    }

    public final ImmutableKmeansContext withExecutor(ExecutorService value) {
        if (this.executor == value) {
            return this;
        }
        ExecutorService newValue = Objects.requireNonNull(value, "executor");
        return new ImmutableKmeansContext(this, newValue, this.progressTracker);
    }

    public final ImmutableKmeansContext withProgressTracker(ProgressTracker value) {
        if (this.progressTracker == value) {
            return this;
        }
        ProgressTracker newValue = Objects.requireNonNull(value, "progressTracker");
        return new ImmutableKmeansContext(this, this.executor, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKmeansContext && this.equalTo((ImmutableKmeansContext)another);
    }

    private boolean equalTo(ImmutableKmeansContext another) {
        return this.executor.equals(another.executor) && this.progressTracker.equals(another.progressTracker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.executor.hashCode();
        h += (h << 5) + this.progressTracker.hashCode();
        return h;
    }

    public String toString() {
        return "KmeansContext{executor=" + this.executor + ", progressTracker=" + this.progressTracker + "}";
    }

    public static KmeansContext of(ExecutorService executor, ProgressTracker progressTracker) {
        return new ImmutableKmeansContext(executor, progressTracker);
    }

    public static KmeansContext copyOf(KmeansContext instance) {
        if (instance instanceof ImmutableKmeansContext) {
            return (ImmutableKmeansContext)instance;
        }
        return ImmutableKmeansContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KmeansContext", generator="Immutables")
    public static final class Builder {
        private ExecutorService executor;
        private ProgressTracker progressTracker;

        private Builder() {
        }

        public final Builder from(KmeansContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.executor(instance.executor());
            this.progressTracker(instance.progressTracker());
            return this;
        }

        public final Builder executor(ExecutorService executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public final Builder progressTracker(ProgressTracker progressTracker) {
            this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
            return this;
        }

        public Builder clear() {
            this.executor = null;
            this.progressTracker = null;
            return this;
        }

        public KmeansContext build() {
            return new ImmutableKmeansContext(this);
        }
    }

    @Generated(from="KmeansContext", generator="Immutables")
    private final class InitShim {
        private byte executorBuildStage = 0;
        private ExecutorService executor;
        private byte progressTrackerBuildStage = 0;
        private ProgressTracker progressTracker;

        private InitShim() {
        }

        ExecutorService executor() {
            if (this.executorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executorBuildStage == 0) {
                this.executorBuildStage = (byte)-1;
                this.executor = Objects.requireNonNull(ImmutableKmeansContext.this.executorInitialize(), "executor");
                this.executorBuildStage = 1;
            }
            return this.executor;
        }

        void executor(ExecutorService executor) {
            this.executor = executor;
            this.executorBuildStage = 1;
        }

        ProgressTracker progressTracker() {
            if (this.progressTrackerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressTrackerBuildStage == 0) {
                this.progressTrackerBuildStage = (byte)-1;
                this.progressTracker = Objects.requireNonNull(ImmutableKmeansContext.this.progressTrackerInitialize(), "progressTracker");
                this.progressTrackerBuildStage = 1;
            }
            return this.progressTracker;
        }

        void progressTracker(ProgressTracker progressTracker) {
            this.progressTracker = progressTracker;
            this.progressTrackerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.executorBuildStage == -1) {
                attributes.add("executor");
            }
            if (this.progressTrackerBuildStage == -1) {
                attributes.add("progressTracker");
            }
            return "Cannot build KmeansContext, attribute initializers form cycle " + attributes;
        }
    }
}

