/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.kmeans.KmeansResult;

@Generated(from="KmeansResult", generator="Immutables")
public final class ImmutableKmeansResult
implements KmeansResult {
    private final HugeIntArray communities;
    private final HugeDoubleArray distanceFromCenter;
    private final double[][] centers;
    private final double averageDistanceToCentroid;
    @Nullable
    private final HugeDoubleArray silhouette;
    private final double averageSilhouette;

    private ImmutableKmeansResult(HugeIntArray communities, HugeDoubleArray distanceFromCenter, double[][] centers, double averageDistanceToCentroid, @Nullable HugeDoubleArray silhouette, double averageSilhouette) {
        this.communities = Objects.requireNonNull(communities, "communities");
        this.distanceFromCenter = Objects.requireNonNull(distanceFromCenter, "distanceFromCenter");
        this.centers = (double[][])centers.clone();
        this.averageDistanceToCentroid = averageDistanceToCentroid;
        this.silhouette = silhouette;
        this.averageSilhouette = averageSilhouette;
    }

    private ImmutableKmeansResult(ImmutableKmeansResult original, HugeIntArray communities, HugeDoubleArray distanceFromCenter, double[][] centers, double averageDistanceToCentroid, @Nullable HugeDoubleArray silhouette, double averageSilhouette) {
        this.communities = communities;
        this.distanceFromCenter = distanceFromCenter;
        this.centers = centers;
        this.averageDistanceToCentroid = averageDistanceToCentroid;
        this.silhouette = silhouette;
        this.averageSilhouette = averageSilhouette;
    }

    @Override
    public HugeIntArray communities() {
        return this.communities;
    }

    @Override
    public HugeDoubleArray distanceFromCenter() {
        return this.distanceFromCenter;
    }

    @Override
    public double[][] centers() {
        return (double[][])this.centers.clone();
    }

    @Override
    public double averageDistanceToCentroid() {
        return this.averageDistanceToCentroid;
    }

    @Override
    @Nullable
    public HugeDoubleArray silhouette() {
        return this.silhouette;
    }

    @Override
    public double averageSilhouette() {
        return this.averageSilhouette;
    }

    public final ImmutableKmeansResult withCommunities(HugeIntArray value) {
        if (this.communities == value) {
            return this;
        }
        HugeIntArray newValue = Objects.requireNonNull(value, "communities");
        return new ImmutableKmeansResult(this, newValue, this.distanceFromCenter, this.centers, this.averageDistanceToCentroid, this.silhouette, this.averageSilhouette);
    }

    public final ImmutableKmeansResult withDistanceFromCenter(HugeDoubleArray value) {
        if (this.distanceFromCenter == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "distanceFromCenter");
        return new ImmutableKmeansResult(this, this.communities, newValue, this.centers, this.averageDistanceToCentroid, this.silhouette, this.averageSilhouette);
    }

    public final ImmutableKmeansResult withCenters(double[] ... elements) {
        double[][] newValue = (double[][])elements.clone();
        return new ImmutableKmeansResult(this, this.communities, this.distanceFromCenter, newValue, this.averageDistanceToCentroid, this.silhouette, this.averageSilhouette);
    }

    public final ImmutableKmeansResult withAverageDistanceToCentroid(double value) {
        if (Double.doubleToLongBits(this.averageDistanceToCentroid) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableKmeansResult(this, this.communities, this.distanceFromCenter, this.centers, value, this.silhouette, this.averageSilhouette);
    }

    public final ImmutableKmeansResult withSilhouette(@Nullable HugeDoubleArray value) {
        if (this.silhouette == value) {
            return this;
        }
        return new ImmutableKmeansResult(this, this.communities, this.distanceFromCenter, this.centers, this.averageDistanceToCentroid, value, this.averageSilhouette);
    }

    public final ImmutableKmeansResult withAverageSilhouette(double value) {
        if (Double.doubleToLongBits(this.averageSilhouette) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableKmeansResult(this, this.communities, this.distanceFromCenter, this.centers, this.averageDistanceToCentroid, this.silhouette, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKmeansResult && this.equalTo((ImmutableKmeansResult)another);
    }

    private boolean equalTo(ImmutableKmeansResult another) {
        return this.communities.equals(another.communities) && this.distanceFromCenter.equals(another.distanceFromCenter) && Arrays.equals((Object[])this.centers, (Object[])another.centers) && Double.doubleToLongBits(this.averageDistanceToCentroid) == Double.doubleToLongBits(another.averageDistanceToCentroid) && Objects.equals(this.silhouette, another.silhouette) && Double.doubleToLongBits(this.averageSilhouette) == Double.doubleToLongBits(another.averageSilhouette);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.communities.hashCode();
        h += (h << 5) + this.distanceFromCenter.hashCode();
        h += (h << 5) + Arrays.hashCode((Object[])this.centers);
        h += (h << 5) + Double.hashCode(this.averageDistanceToCentroid);
        h += (h << 5) + Objects.hashCode(this.silhouette);
        h += (h << 5) + Double.hashCode(this.averageSilhouette);
        return h;
    }

    public String toString() {
        return "KmeansResult{communities=" + this.communities + ", distanceFromCenter=" + this.distanceFromCenter + ", centers=" + Arrays.toString((Object[])this.centers) + ", averageDistanceToCentroid=" + this.averageDistanceToCentroid + ", silhouette=" + this.silhouette + ", averageSilhouette=" + this.averageSilhouette + "}";
    }

    public static KmeansResult of(HugeIntArray communities, HugeDoubleArray distanceFromCenter, double[][] centers, double averageDistanceToCentroid, @Nullable HugeDoubleArray silhouette, double averageSilhouette) {
        return new ImmutableKmeansResult(communities, distanceFromCenter, centers, averageDistanceToCentroid, silhouette, averageSilhouette);
    }

    public static KmeansResult copyOf(KmeansResult instance) {
        if (instance instanceof ImmutableKmeansResult) {
            return (ImmutableKmeansResult)instance;
        }
        return ImmutableKmeansResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KmeansResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COMMUNITIES = 1L;
        private static final long INIT_BIT_DISTANCE_FROM_CENTER = 2L;
        private static final long INIT_BIT_CENTERS = 4L;
        private static final long INIT_BIT_AVERAGE_DISTANCE_TO_CENTROID = 8L;
        private static final long INIT_BIT_AVERAGE_SILHOUETTE = 16L;
        private long initBits = 31L;
        private HugeIntArray communities;
        private HugeDoubleArray distanceFromCenter;
        private double[][] centers;
        private double averageDistanceToCentroid;
        private HugeDoubleArray silhouette;
        private double averageSilhouette;

        private Builder() {
        }

        public final Builder from(KmeansResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.communities(instance.communities());
            this.distanceFromCenter(instance.distanceFromCenter());
            this.centers(instance.centers());
            this.averageDistanceToCentroid(instance.averageDistanceToCentroid());
            @Nullable HugeDoubleArray silhouetteValue = instance.silhouette();
            if (silhouetteValue != null) {
                this.silhouette(silhouetteValue);
            }
            this.averageSilhouette(instance.averageSilhouette());
            return this;
        }

        public final Builder communities(HugeIntArray communities) {
            this.communities = Objects.requireNonNull(communities, "communities");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder distanceFromCenter(HugeDoubleArray distanceFromCenter) {
            this.distanceFromCenter = Objects.requireNonNull(distanceFromCenter, "distanceFromCenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder centers(double[] ... centers) {
            this.centers = (double[][])centers.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder averageDistanceToCentroid(double averageDistanceToCentroid) {
            this.averageDistanceToCentroid = averageDistanceToCentroid;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder silhouette(@Nullable HugeDoubleArray silhouette) {
            this.silhouette = silhouette;
            return this;
        }

        public final Builder averageSilhouette(double averageSilhouette) {
            this.averageSilhouette = averageSilhouette;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.communities = null;
            this.distanceFromCenter = null;
            this.centers = null;
            this.averageDistanceToCentroid = 0.0;
            this.silhouette = null;
            this.averageSilhouette = 0.0;
            return this;
        }

        public KmeansResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKmeansResult(null, this.communities, this.distanceFromCenter, this.centers, this.averageDistanceToCentroid, this.silhouette, this.averageSilhouette);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("communities");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("distanceFromCenter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("centers");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("averageDistanceToCentroid");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("averageSilhouette");
            }
            return "Cannot build KmeansResult, some of required attributes are not set " + attributes;
        }
    }
}

