/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.kmeans.KmeansBaseConfig;
import org.neo4j.gds.kmeans.KmeansSampler;
import org.neo4j.gds.kmeans.KmeansStatsConfig;

@Generated(from="KmeansStatsConfig", generator="Immutables")
public final class ImmutableKmeansStatsConfig
implements KmeansStatsConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Long randomSeed;
    private final int maxIterations;
    private final int k;
    private final double deltaThreshold;
    private final int numberOfRestarts;
    private final boolean computeSilhouette;
    private final String nodeProperty;
    private final KmeansSampler.SamplerType initialSampler;
    private final List<List<Double>> seedCentroids;
    private final transient boolean isSeeded;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKmeansStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, Iterable<? extends List<Double>> seedCentroids) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(nodeLabels, true, false)));
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.maxIterations(maxIterations);
        this.initShim.k(k);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.numberOfRestarts(numberOfRestarts);
        this.initShim.computeSilhouette(computeSilhouette);
        this.nodeProperty = Objects.requireNonNull(nodeProperty, "nodeProperty");
        this.initShim.initialSampler(Objects.requireNonNull(initialSampler, "initialSampler"));
        this.initShim.seedCentroids(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(seedCentroids, true, false)));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.k = this.initShim.k();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.numberOfRestarts = this.initShim.numberOfRestarts();
        this.computeSilhouette = this.initShim.computeSilhouette();
        this.initialSampler = this.initShim.initialSampler();
        this.seedCentroids = this.initShim.seedCentroids();
        this.isSeeded = this.initShim.isSeeded();
        this.initShim = null;
    }

    private ImmutableKmeansStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, Iterable<? extends List<Double>> seedCentroids) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(nodeLabels, true, false)));
        this.randomSeed = randomSeed;
        this.initShim.maxIterations(maxIterations);
        this.initShim.k(k);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.numberOfRestarts(numberOfRestarts);
        this.initShim.computeSilhouette(computeSilhouette);
        this.nodeProperty = Objects.requireNonNull(nodeProperty, "nodeProperty");
        this.initShim.initialSampler(Objects.requireNonNull(initialSampler, "initialSampler"));
        this.initShim.seedCentroids(ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(seedCentroids, true, false)));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.k = this.initShim.k();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.numberOfRestarts = this.initShim.numberOfRestarts();
        this.computeSilhouette = this.initShim.computeSilhouette();
        this.initialSampler = this.initShim.initialSampler();
        this.seedCentroids = this.initShim.seedCentroids();
        this.isSeeded = this.initShim.isSeeded();
        this.initShim = null;
    }

    private ImmutableKmeansStatsConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.randomSeed = builder.randomSeed;
        this.nodeProperty = builder.nodeProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableKmeansStatsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableKmeansStatsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.kIsSet()) {
            this.initShim.k(builder.k);
        }
        if (builder.deltaThresholdIsSet()) {
            this.initShim.deltaThreshold(builder.deltaThreshold);
        }
        if (builder.numberOfRestartsIsSet()) {
            this.initShim.numberOfRestarts(builder.numberOfRestarts);
        }
        if (builder.computeSilhouetteIsSet()) {
            this.initShim.computeSilhouette(builder.computeSilhouette);
        }
        if (builder.initialSampler != null) {
            this.initShim.initialSampler(builder.initialSampler);
        }
        if (builder.seedCentroidsIsSet()) {
            this.initShim.seedCentroids(builder.seedCentroids == null ? Collections.emptyList() : ImmutableKmeansStatsConfig.createUnmodifiableList(true, builder.seedCentroids));
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.k = this.initShim.k();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.numberOfRestarts = this.initShim.numberOfRestarts();
        this.computeSilhouette = this.initShim.computeSilhouette();
        this.initialSampler = this.initShim.initialSampler();
        this.seedCentroids = this.initShim.seedCentroids();
        this.isSeeded = this.initShim.isSeeded();
        this.initShim = null;
    }

    private ImmutableKmeansStatsConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, Long randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, List<List<Double>> seedCentroids) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.randomSeed = randomSeed;
        this.initShim.maxIterations(maxIterations);
        this.initShim.k(k);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.numberOfRestarts(numberOfRestarts);
        this.initShim.computeSilhouette(computeSilhouette);
        this.nodeProperty = nodeProperty;
        this.initShim.initialSampler(initialSampler);
        this.initShim.seedCentroids(seedCentroids);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.k = this.initShim.k();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.numberOfRestarts = this.initShim.numberOfRestarts();
        this.computeSilhouette = this.initShim.computeSilhouette();
        this.initialSampler = this.initShim.initialSampler();
        this.seedCentroids = this.initShim.seedCentroids();
        this.isSeeded = this.initShim.isSeeded();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return KmeansStatsConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return KmeansStatsConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return KmeansStatsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return KmeansStatsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return KmeansStatsConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return KmeansStatsConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return KmeansStatsConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return KmeansStatsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return KmeansStatsConfig.super.nodeLabels();
    }

    private int maxIterationsInitialize() {
        return KmeansStatsConfig.super.maxIterations();
    }

    private int kInitialize() {
        return KmeansStatsConfig.super.k();
    }

    private double deltaThresholdInitialize() {
        return KmeansStatsConfig.super.deltaThreshold();
    }

    private int numberOfRestartsInitialize() {
        return KmeansStatsConfig.super.numberOfRestarts();
    }

    private boolean computeSilhouetteInitialize() {
        return KmeansStatsConfig.super.computeSilhouette();
    }

    private KmeansSampler.SamplerType initialSamplerInitialize() {
        return KmeansStatsConfig.super.initialSampler();
    }

    private List<List<Double>> seedCentroidsInitialize() {
        return KmeansStatsConfig.super.seedCentroids();
    }

    private boolean isSeededInitialize() {
        return KmeansStatsConfig.super.isSeeded();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int k() {
        InitShim shim = this.initShim;
        return shim != null ? shim.k() : this.k;
    }

    @Override
    public double deltaThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deltaThreshold() : this.deltaThreshold;
    }

    @Override
    public int numberOfRestarts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numberOfRestarts() : this.numberOfRestarts;
    }

    @Override
    public boolean computeSilhouette() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeSilhouette() : this.computeSilhouette;
    }

    @Override
    public String nodeProperty() {
        return this.nodeProperty;
    }

    @Override
    public KmeansSampler.SamplerType initialSampler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialSampler() : this.initialSampler;
    }

    @Override
    public List<List<Double>> seedCentroids() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedCentroids() : this.seedCentroids;
    }

    @Override
    public boolean isSeeded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSeeded() : this.isSeeded;
    }

    public final ImmutableKmeansStatsConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(elements, true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(elements, true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, value, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withK(int value) {
        if (this.k == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, value, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withDeltaThreshold(double value) {
        if (Double.doubleToLongBits(this.deltaThreshold) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, value, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withNumberOfRestarts(int value) {
        if (this.numberOfRestarts == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, value, this.computeSilhouette, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withComputeSilhouette(boolean value) {
        if (this.computeSilhouette == value) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, value, this.nodeProperty, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withNodeProperty(String value) {
        String newValue = Objects.requireNonNull(value, "nodeProperty");
        if (this.nodeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, newValue, this.initialSampler, this.seedCentroids));
    }

    public final ImmutableKmeansStatsConfig withInitialSampler(KmeansSampler.SamplerType value) {
        if (this.initialSampler == value) {
            return this;
        }
        KmeansSampler.SamplerType newValue = Objects.requireNonNull(value, "initialSampler");
        if (this.initialSampler.equals((Object)newValue)) {
            return this;
        }
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, newValue, this.seedCentroids));
    }

    @SafeVarargs
    public final ImmutableKmeansStatsConfig withSeedCentroids(List<Double> ... elements) {
        List<List<Double>> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, newValue));
    }

    public final ImmutableKmeansStatsConfig withSeedCentroids(Iterable<? extends List<Double>> elements) {
        if (this.seedCentroids == elements) {
            return this;
        }
        List<List<Double>> newValue = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(elements, true, false));
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.maxIterations, this.k, this.deltaThreshold, this.numberOfRestarts, this.computeSilhouette, this.nodeProperty, this.initialSampler, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKmeansStatsConfig && this.equalTo((ImmutableKmeansStatsConfig)another);
    }

    private boolean equalTo(ImmutableKmeansStatsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.randomSeed, another.randomSeed) && this.maxIterations == another.maxIterations && this.k == another.k && Double.doubleToLongBits(this.deltaThreshold) == Double.doubleToLongBits(another.deltaThreshold) && this.numberOfRestarts == another.numberOfRestarts && this.computeSilhouette == another.computeSilhouette && this.nodeProperty.equals(another.nodeProperty) && this.initialSampler.equals((Object)another.initialSampler) && this.seedCentroids.equals(another.seedCentroids) && this.isSeeded == another.isSeeded;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.k;
        h += (h << 5) + Double.hashCode(this.deltaThreshold);
        h += (h << 5) + this.numberOfRestarts;
        h += (h << 5) + Boolean.hashCode(this.computeSilhouette);
        h += (h << 5) + this.nodeProperty.hashCode();
        h += (h << 5) + this.initialSampler.hashCode();
        h += (h << 5) + this.seedCentroids.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isSeeded);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("KmeansStatsConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 18) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("k=").append(this.k);
        builder.append(", ");
        builder.append("deltaThreshold=").append(this.deltaThreshold);
        builder.append(", ");
        builder.append("numberOfRestarts=").append(this.numberOfRestarts);
        builder.append(", ");
        builder.append("computeSilhouette=").append(this.computeSilhouette);
        builder.append(", ");
        builder.append("nodeProperty=").append(this.nodeProperty);
        builder.append(", ");
        builder.append("initialSampler=").append((Object)this.initialSampler);
        builder.append(", ");
        builder.append("seedCentroids=").append(this.seedCentroids);
        builder.append(", ");
        builder.append("isSeeded=").append(this.isSeeded);
        return builder.append("}").toString();
    }

    public static KmeansStatsConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<Long> randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, List<List<Double>> seedCentroids) {
        return ImmutableKmeansStatsConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, randomSeed, maxIterations, k, deltaThreshold, numberOfRestarts, computeSilhouette, nodeProperty, initialSampler, seedCentroids);
    }

    public static KmeansStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, Iterable<? extends List<Double>> seedCentroids) {
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, randomSeed, maxIterations, k, deltaThreshold, numberOfRestarts, computeSilhouette, nodeProperty, initialSampler, seedCentroids));
    }

    public static KmeansStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long randomSeed, int maxIterations, int k, double deltaThreshold, int numberOfRestarts, boolean computeSilhouette, String nodeProperty, KmeansSampler.SamplerType initialSampler, Iterable<? extends List<Double>> seedCentroids) {
        return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, randomSeed, maxIterations, k, deltaThreshold, numberOfRestarts, computeSilhouette, nodeProperty, initialSampler, seedCentroids));
    }

    private static ImmutableKmeansStatsConfig validate(ImmutableKmeansStatsConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static KmeansStatsConfig copyOf(KmeansStatsConfig instance) {
        if (instance instanceof ImmutableKmeansStatsConfig) {
            return (ImmutableKmeansStatsConfig)instance;
        }
        return ImmutableKmeansStatsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="KmeansStatsConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_MAX_ITERATIONS = 64L;
        private static final long OPT_BIT_K = 128L;
        private static final long OPT_BIT_DELTA_THRESHOLD = 256L;
        private static final long OPT_BIT_NUMBER_OF_RESTARTS = 512L;
        private static final long OPT_BIT_COMPUTE_SILHOUETTE = 1024L;
        private static final long OPT_BIT_SEED_CENTROIDS = 2048L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private Long randomSeed;
        private int maxIterations;
        private int k;
        private double deltaThreshold;
        private int numberOfRestarts;
        private boolean computeSilhouette;
        private String nodeProperty;
        private KmeansSampler.SamplerType initialSampler;
        private List<List<Double>> seedCentroids = null;

        private Builder() {
        }

        public final Builder from(KmeansBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KmeansStatsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            KmeansBaseConfig instance;
            long bits = 0L;
            if (object instanceof KmeansBaseConfig) {
                instance = (KmeansBaseConfig)object;
                this.nodeProperty(instance.nodeProperty());
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.addAllSeedCentroids(instance.seedCentroids());
                this.initialSampler(instance.initialSampler());
                this.k(instance.k());
                this.deltaThreshold(instance.deltaThreshold());
                this.computeSilhouette(instance.computeSilhouette());
                this.numberOfRestarts(instance.numberOfRestarts());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder k(int k) {
            this.k = k;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder deltaThreshold(double deltaThreshold) {
            this.deltaThreshold = deltaThreshold;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder numberOfRestarts(int numberOfRestarts) {
            this.numberOfRestarts = numberOfRestarts;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder computeSilhouette(boolean computeSilhouette) {
            this.computeSilhouette = computeSilhouette;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder nodeProperty(String nodeProperty) {
            this.nodeProperty = Objects.requireNonNull(nodeProperty, "nodeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder initialSampler(KmeansSampler.SamplerType initialSampler) {
            this.initialSampler = Objects.requireNonNull(initialSampler, "initialSampler");
            return this;
        }

        public final Builder addSeedCentroid(List<Double> element) {
            if (this.seedCentroids == null) {
                this.seedCentroids = new ArrayList<List<Double>>();
            }
            this.seedCentroids.add(Objects.requireNonNull(element, "seedCentroids element"));
            this.optBits |= 0x800L;
            return this;
        }

        @SafeVarargs
        public final Builder addSeedCentroids(List<Double> ... elements) {
            if (this.seedCentroids == null) {
                this.seedCentroids = new ArrayList<List<Double>>();
            }
            for (List<Double> element : elements) {
                this.seedCentroids.add(Objects.requireNonNull(element, "seedCentroids element"));
            }
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder seedCentroids(Iterable<? extends List<Double>> elements) {
            this.seedCentroids = new ArrayList<List<Double>>();
            return this.addAllSeedCentroids(elements);
        }

        public final Builder addAllSeedCentroids(Iterable<? extends List<Double>> elements) {
            Objects.requireNonNull(elements, "seedCentroids element");
            if (this.seedCentroids == null) {
                this.seedCentroids = new ArrayList<List<Double>>();
            }
            for (List<Double> list : elements) {
                this.seedCentroids.add(Objects.requireNonNull(list, "seedCentroids element"));
            }
            this.optBits |= 0x800L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.randomSeed = null;
            this.maxIterations = 0;
            this.k = 0;
            this.deltaThreshold = 0.0;
            this.numberOfRestarts = 0;
            this.computeSilhouette = false;
            this.nodeProperty = null;
            this.initialSampler = null;
            if (this.seedCentroids != null) {
                this.seedCentroids.clear();
            }
            return this;
        }

        public KmeansStatsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableKmeansStatsConfig.validate(new ImmutableKmeansStatsConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean kIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean deltaThresholdIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean numberOfRestartsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean computeSilhouetteIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean seedCentroidsIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeProperty");
            }
            return "Cannot build KmeansStatsConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="KmeansStatsConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte kBuildStage = 0;
        private int k;
        private byte deltaThresholdBuildStage = 0;
        private double deltaThreshold;
        private byte numberOfRestartsBuildStage = 0;
        private int numberOfRestarts;
        private byte computeSilhouetteBuildStage = 0;
        private boolean computeSilhouette;
        private byte initialSamplerBuildStage = 0;
        private KmeansSampler.SamplerType initialSampler;
        private byte seedCentroidsBuildStage = 0;
        private List<List<Double>> seedCentroids;
        private byte isSeededBuildStage = 0;
        private boolean isSeeded;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableKmeansStatsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableKmeansStatsConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableKmeansStatsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableKmeansStatsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableKmeansStatsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableKmeansStatsConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableKmeansStatsConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(ImmutableKmeansStatsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(ImmutableKmeansStatsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableKmeansStatsConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int k() {
            if (this.kBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.kBuildStage == 0) {
                this.kBuildStage = (byte)-1;
                this.k = ImmutableKmeansStatsConfig.this.kInitialize();
                this.kBuildStage = 1;
            }
            return this.k;
        }

        void k(int k) {
            this.k = k;
            this.kBuildStage = 1;
        }

        double deltaThreshold() {
            if (this.deltaThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deltaThresholdBuildStage == 0) {
                this.deltaThresholdBuildStage = (byte)-1;
                this.deltaThreshold = ImmutableKmeansStatsConfig.this.deltaThresholdInitialize();
                this.deltaThresholdBuildStage = 1;
            }
            return this.deltaThreshold;
        }

        void deltaThreshold(double deltaThreshold) {
            this.deltaThreshold = deltaThreshold;
            this.deltaThresholdBuildStage = 1;
        }

        int numberOfRestarts() {
            if (this.numberOfRestartsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numberOfRestartsBuildStage == 0) {
                this.numberOfRestartsBuildStage = (byte)-1;
                this.numberOfRestarts = ImmutableKmeansStatsConfig.this.numberOfRestartsInitialize();
                this.numberOfRestartsBuildStage = 1;
            }
            return this.numberOfRestarts;
        }

        void numberOfRestarts(int numberOfRestarts) {
            this.numberOfRestarts = numberOfRestarts;
            this.numberOfRestartsBuildStage = 1;
        }

        boolean computeSilhouette() {
            if (this.computeSilhouetteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeSilhouetteBuildStage == 0) {
                this.computeSilhouetteBuildStage = (byte)-1;
                this.computeSilhouette = ImmutableKmeansStatsConfig.this.computeSilhouetteInitialize();
                this.computeSilhouetteBuildStage = 1;
            }
            return this.computeSilhouette;
        }

        void computeSilhouette(boolean computeSilhouette) {
            this.computeSilhouette = computeSilhouette;
            this.computeSilhouetteBuildStage = 1;
        }

        KmeansSampler.SamplerType initialSampler() {
            if (this.initialSamplerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialSamplerBuildStage == 0) {
                this.initialSamplerBuildStage = (byte)-1;
                this.initialSampler = Objects.requireNonNull(ImmutableKmeansStatsConfig.this.initialSamplerInitialize(), "initialSampler");
                this.initialSamplerBuildStage = 1;
            }
            return this.initialSampler;
        }

        void initialSampler(KmeansSampler.SamplerType initialSampler) {
            this.initialSampler = initialSampler;
            this.initialSamplerBuildStage = 1;
        }

        List<List<Double>> seedCentroids() {
            if (this.seedCentroidsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedCentroidsBuildStage == 0) {
                this.seedCentroidsBuildStage = (byte)-1;
                this.seedCentroids = ImmutableKmeansStatsConfig.createUnmodifiableList(false, ImmutableKmeansStatsConfig.createSafeList(ImmutableKmeansStatsConfig.this.seedCentroidsInitialize(), true, false));
                this.seedCentroidsBuildStage = 1;
            }
            return this.seedCentroids;
        }

        void seedCentroids(List<List<Double>> seedCentroids) {
            this.seedCentroids = seedCentroids;
            this.seedCentroidsBuildStage = 1;
        }

        boolean isSeeded() {
            if (this.isSeededBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSeededBuildStage == 0) {
                this.isSeededBuildStage = (byte)-1;
                this.isSeeded = ImmutableKmeansStatsConfig.this.isSeededInitialize();
                this.isSeededBuildStage = 1;
            }
            return this.isSeeded;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.kBuildStage == -1) {
                attributes.add("k");
            }
            if (this.deltaThresholdBuildStage == -1) {
                attributes.add("deltaThreshold");
            }
            if (this.numberOfRestartsBuildStage == -1) {
                attributes.add("numberOfRestarts");
            }
            if (this.computeSilhouetteBuildStage == -1) {
                attributes.add("computeSilhouette");
            }
            if (this.initialSamplerBuildStage == -1) {
                attributes.add("initialSampler");
            }
            if (this.seedCentroidsBuildStage == -1) {
                attributes.add("seedCentroids");
            }
            if (this.isSeededBuildStage == -1) {
                attributes.add("isSeeded");
            }
            return "Cannot build KmeansStatsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

