/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.Collection;
import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.kmeans.KmeansSampler;
import org.neo4j.gds.utils.StringFormatting;

public interface KmeansBaseConfig
extends AlgoBaseConfig,
IterationsConfig,
RandomSeedConfig {
    @Configuration.IntegerRange(min=1)
    @Value.Default
    default public int maxIterations() {
        return 10;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int k() {
        return 10;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double deltaThreshold() {
        return 0.05;
    }

    @Configuration.IntegerRange(min=1)
    @Value.Default
    default public int numberOfRestarts() {
        return 1;
    }

    @Value.Default
    default public boolean computeSilhouette() {
        return false;
    }

    public String nodeProperty();

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void nodePropertyTypeValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ValueType valueType = graphStore.nodeProperty(this.nodeProperty()).valueType();
        if (valueType == ValueType.DOUBLE_ARRAY || valueType == ValueType.FLOAT_ARRAY) {
            return;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported node property value type [%s]. Value type required: [%s] or [%s].", (Object[])new Object[]{valueType, ValueType.DOUBLE_ARRAY, ValueType.FLOAT_ARRAY}));
    }

    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.kmeans.KmeansSampler.SamplerType#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.kmeans.KmeansSampler.SamplerType#toString")
    default public KmeansSampler.SamplerType initialSampler() {
        return KmeansSampler.SamplerType.UNIFORM;
    }

    @Value.Default
    default public List<List<Double>> seedCentroids() {
        return List.of();
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean isSeeded() {
        return !this.seedCentroids().isEmpty();
    }
}

