/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.KmeansSampler;
import org.neo4j.gds.kmeans.KmeansTask;
import org.neo4j.gds.kmeans.TaskPhase;

public class KmeansPlusPlusSampler
extends KmeansSampler {
    private List<KmeansTask> tasks;
    private final int concurrency;
    private final ProgressTracker progressTracker;
    private final HugeDoubleArray distanceFromClosestCentroid;
    private final ExecutorService executorService;
    private NodePropertyValues nodePropertyValues;

    public KmeansPlusPlusSampler(SplittableRandom random, ClusterManager clusterManager, long nodeCount, int k, NodePropertyValues nodePropertyValues, HugeDoubleArray distanceFromClosestCentroid, int concurrency, ExecutorService executorService, List<KmeansTask> tasks, ProgressTracker progressTracker) {
        super(random, clusterManager, nodeCount, k);
        this.nodePropertyValues = nodePropertyValues;
        this.distanceFromClosestCentroid = distanceFromClosestCentroid;
        this.executorService = executorService;
        this.tasks = tasks;
        this.concurrency = concurrency;
        this.progressTracker = progressTracker;
    }

    @Override
    public void performInitialSampling() {
        long firstId = this.random.nextLong(this.nodeCount);
        BitSet bitSet = new BitSet(this.nodeCount);
        this.assignToCluster(bitSet, 0, firstId);
        this.progressTracker.logProgress(1L);
        for (int selectionClusterId = 1; selectionClusterId < this.k; ++selectionClusterId) {
            RunWithConcurrency.builder().concurrency(this.concurrency).tasks(this.tasks).executor(this.executorService).run();
            double squaredDistance = 0.0;
            for (KmeansTask task : this.tasks) {
                squaredDistance += task.getSquaredDistance();
            }
            long nextNode = -1L;
            if (!Double.isInfinite(squaredDistance) && !(squaredDistance <= 0.0)) {
                double x = this.random.nextDouble() * squaredDistance;
                double curr = 0.0;
                for (long nodeId = 0L; nodeId < this.nodeCount; ++nodeId) {
                    double distanceFromCentroid = this.distanceFromClosestCentroid.get(nodeId);
                    if (distanceFromCentroid <= -1.0 || !(x <= (curr += distanceFromCentroid * distanceFromCentroid))) continue;
                    nextNode = nodeId;
                    break;
                }
            }
            if (nextNode == -1L) {
                nextNode = this.random.nextLong(this.nodeCount);
                while (bitSet.get(nextNode)) {
                    nextNode = this.random.nextLong(this.nodeCount);
                }
            }
            this.assignToCluster(bitSet, selectionClusterId, nextNode);
            this.progressTracker.logProgress(1L);
        }
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(this.tasks).executor(this.executorService).run();
        for (KmeansTask task : this.tasks) {
            task.switchToPhase(TaskPhase.ITERATION);
        }
    }

    private void assignToCluster(BitSet bitSet, int position, long nextNode) {
        bitSet.set(nextNode);
        this.clusterManager.initialAssignCluster(nextNode);
        this.distanceFromClosestCentroid.set(nextNode, (double)(-(position + 1)));
    }
}

