/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.KmeansPlusPlusSampler;
import org.neo4j.gds.kmeans.KmeansTask;
import org.neo4j.gds.kmeans.KmeansUniformSampler;
import org.neo4j.gds.utils.StringFormatting;

public abstract class KmeansSampler {
    final SplittableRandom random;
    final int k;
    final long nodeCount;
    final ClusterManager clusterManager;

    public abstract void performInitialSampling();

    public KmeansSampler(SplittableRandom random, ClusterManager clusterManager, long nodeCount, int k) {
        this.random = random;
        this.nodeCount = nodeCount;
        this.clusterManager = clusterManager;
        this.k = k;
    }

    public static KmeansSampler createSampler(SamplerType samplerType, SplittableRandom random, NodePropertyValues nodePropertyValues, ClusterManager clusterManager, long nodeCount, int k, int concurrency, HugeDoubleArray distanceFromCenter, ExecutorService executorService, List<KmeansTask> tasks, ProgressTracker progressTracker) {
        if (samplerType == SamplerType.UNIFORM) {
            return new KmeansUniformSampler(random, clusterManager, nodeCount, k, progressTracker);
        }
        return new KmeansPlusPlusSampler(random, clusterManager, nodeCount, k, nodePropertyValues, distanceFromCenter, concurrency, executorService, tasks, progressTracker);
    }

    public static enum SamplerType {
        UNIFORM("UNIFORM", "UNIFORM"),
        KMEANSPP("KMEANS++", "KMEANSPP");

        private String samplerName;
        private String samplerType;
        private static final Map<String, String> VALUES;

        private SamplerType(String samplerName, String samplerType) {
            this.samplerName = samplerName;
            this.samplerType = samplerType;
        }

        public String getSamplerName() {
            return this.samplerName;
        }

        public String getSamplerType() {
            return this.samplerType;
        }

        public static SamplerType parse(Object input) {
            if (input instanceof String) {
                String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
                if (VALUES.containsKey(inputString)) {
                    return SamplerType.valueOf(VALUES.get(inputString));
                }
                throw new IllegalArgumentException(String.format(Locale.getDefault(), "Sampler `%s` is not supported. Must be one of: %s.", inputString, VALUES));
            }
            if (input instanceof SamplerType) {
                return (SamplerType)((Object)input);
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected Sampler or String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
        }

        public static String toString(SamplerType samplerType) {
            return samplerType.toString();
        }

        static {
            VALUES = Arrays.stream(SamplerType.values()).collect(Collectors.toMap(SamplerType::getSamplerName, SamplerType::getSamplerType));
        }
    }
}

